/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.recipes.producers.blender;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IStage;
import tv.soaryn.xycraft.core.content.recipe.IRecipeBuilder;
import tv.soaryn.xycraft.machines.content.recipes.producers.blender.BlenderRecipe;

public class BlenderRecipeBuilder
implements IRecipeBuilder.WithItem.Input<BlenderRecipeBuilder, BlenderRecipe>,
IRecipeBuilder.WithItem.Output<BlenderRecipeBuilder, BlenderRecipe>,
IRecipeBuilder.WithFluid.Input<BlenderRecipeBuilder, BlenderRecipe>,
IRecipeBuilder.WithFluid.Output<BlenderRecipeBuilder, BlenderRecipe>,
IRecipeBuilder.WithStage<BlenderRecipeBuilder, BlenderRecipe> {
    private Either<SizedFluidIngredient, SizedIngredient> _input1 = null;
    private Optional<Either<SizedFluidIngredient, SizedIngredient>> _input2 = Optional.empty();
    private Either<FluidStack, ItemStack> _output = null;
    private long _ticks = 100L;
    private Optional<IStage> _requiredStage = Optional.empty();

    public static BlenderRecipeBuilder create() {
        return new BlenderRecipeBuilder();
    }

    @NotNull
    public BlenderRecipeBuilder requires(IStage stage) {
        this._requiredStage = Optional.of(stage);
        return this;
    }

    public BlenderRecipeBuilder input(SizedIngredient inputIngredient) {
        if (this._input1 == null) {
            this._input1 = Either.right((Object)inputIngredient);
        } else if (this._input2.isEmpty()) {
            this._input2 = Optional.of(Either.right((Object)inputIngredient));
        } else {
            throw new IllegalArgumentException("Too many inputs in Blender Recipe!");
        }
        return this;
    }

    public BlenderRecipeBuilder input(SizedFluidIngredient inputIngredient) {
        if (this._input1 == null) {
            this._input1 = Either.left((Object)inputIngredient);
        } else if (this._input2.isEmpty()) {
            this._input2 = Optional.of(Either.left((Object)inputIngredient));
        } else {
            throw new IllegalArgumentException("Too many inputs in Blender Recipe!");
        }
        return this;
    }

    public BlenderRecipeBuilder output(ItemStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Blender Recipe!");
        }
        this._output = Either.right((Object)outputIngredient);
        return this;
    }

    public BlenderRecipeBuilder output(FluidStack outputIngredient) {
        if (this._output != null) {
            throw new IllegalArgumentException("Too many outputs in Blender Recipe!");
        }
        this._output = Either.left((Object)outputIngredient);
        return this;
    }

    @NotNull
    public BlenderRecipeBuilder ticks(long ticks) {
        this._ticks = ticks;
        return this;
    }

    @NotNull
    public BlenderRecipe makeRecipe() {
        return new BlenderRecipe(this._input1, this._input2, this._output, this._ticks, this._requiredStage);
    }

    public void ensureValid(String id) {
        if (this._input1 == null) {
            throw new RuntimeException("Ingredient is null in Blender recipe - " + id);
        }
        if (this._output == null) {
            throw new RuntimeException("No output in Blender recipe - " + id);
        }
        if (this._ticks <= 0L) {
            throw new RuntimeException("No ticks in Blender recipe - " + id);
        }
    }
}

