/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.tank;

import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import tv.soaryn.xycraft.machines.content.multiblock.tank.IOGroup;
import tv.soaryn.xycraft.machines.content.multiblock.tank.TankOperation;

public class MultiTankFluidCache {
    private final Reference2LongMap<IOGroup> cache = new Reference2LongOpenHashMap();
    private final TankOperation operation;

    public MultiTankFluidCache(TankOperation operation) {
        this.operation = operation;
    }

    public long get(IOGroup group) {
        return this.cache.computeIfAbsent((Object)group, IOGroup::getFluidAmount);
    }

    public void set(IOGroup group, long amount) {
        this.cache.put((Object)group, amount);
    }

    public void commit() {
        this.cache.forEach((group, amount) -> group.setFluidAmount((long)amount, this.operation));
    }
}

