/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular206;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.items.modular.proto.ITool;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.MineLogicModule;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.MiningSpeedModule;
import tv.soaryn.xycraft.machines.content.items.modular206.VariableItem;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class GauntletItemNew
extends VariableItem
implements ITool {
    private final Tier _tier;
    private static final MiningSpeedModule.IMineSpeed neutral = (base, state) -> 1.0f;

    public GauntletItemNew(Tier tier, Item.Properties properties) {
        super(properties, EquipmentSlotGroup.HAND);
        this._tier = tier;
    }

    public GauntletItemNew(Tier tier) {
        this(tier, new Item.Properties());
    }

    public static GauntletItemNew basic(Item.Properties ignored) {
        return new GauntletItemNew((Tier)Tiers.IRON);
    }

    public static GauntletItemNew improved(Item.Properties ignored) {
        return new GauntletItemNew((Tier)Tiers.DIAMOND);
    }

    public static GauntletItemNew perfected(Item.Properties ignored) {
        return new GauntletItemNew((Tier)Tiers.NETHERITE, new Item.Properties().fireResistant());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        IModuleContainer storage;
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && (storage = (IModuleContainer)stack.getCapability(CoreCapabilities.ModuleContainer.ITEM)) != null && storage.getInstalledModules().stream().anyMatch(moduleRecord -> moduleRecord.module() instanceof MineLogicModule)) {
            stack.set(MachinesDataComponents.ToolActivation, (Object)((Boolean)stack.getOrDefault(MachinesDataComponents.ToolActivation, (Object)false) == false ? 1 : 0));
            return InteractionResultHolder.consume((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, @NotNull BlockState state) {
        return this.isTierValid(state);
    }

    private boolean isTierValid(BlockState state) {
        return this._tier == Tiers.NETHERITE || !state.is(this._tier.getIncorrectBlocksForDrops());
    }

    public MiningSpeedModule.IMineSpeed getModuleMiningSpeed(IModuleContainer storage) {
        List installedModules = storage.getInstalledModules();
        for (IModuleContainer.ModuleRecord module : installedModules) {
            IModule iModule = module.module();
            if (!(iModule instanceof MiningSpeedModule)) continue;
            MiningSpeedModule miningSpeedModule = (MiningSpeedModule)iModule;
            return miningSpeedModule.speed();
        }
        return neutral;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        if (!this.isTierValid(state)) {
            return 1.0f;
        }
        IModuleContainer cap = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM);
        if (cap == null) {
            return 1.0f;
        }
        Optional<IModuleContainer.ModuleRecord> speedModule = cap.getInstalledModules().stream().filter(moduleRecord -> moduleRecord.module() instanceof MiningSpeedModule).findAny();
        if (speedModule.isEmpty()) {
            return 1.0f;
        }
        return Math.max((float)1.0f, (float)this.getModuleMiningSpeed(cap).getSpeed(this._tier.getSpeed() - 2.0f, state));
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        return true;
    }

    @SubscribeEvent
    public static void registerStorageCapabilities(RegisterCapabilitiesEvent event) {
        for (Item registeredItem : BuiltInRegistries.ITEM) {
            if (!(registeredItem instanceof GauntletItemNew)) continue;
            GauntletItemNew gauntlet = (GauntletItemNew)registeredItem;
            event.registerItem(CoreCapabilities.EnergyConsumable.ITEM, (stack, context) -> GauntletItemNew.createEnergyConsumer(stack, context, XyMachines.ServerConfig.GauntletEnergyCost), new ItemLike[]{gauntlet});
            event.registerItem(CoreCapabilities.ModuleContainer.ITEM, VariableItem::createBasicModularStorage, new ItemLike[]{gauntlet});
        }
    }
}

