/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.config.CoreClientConfig;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.items.IHandleCreativeTab;
import tv.soaryn.xycraft.core.content.items.XyItem;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class FoilItem
extends XyItem
implements IColoredBlock,
IHandleCreativeTab {
    public FoilItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(@NotNull ItemStack itemStack) {
        return MachinesContent.Item.Foil.asItem().getDefaultInstance();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !((SimpleFluidContent)stack.getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.EMPTY)).isEmpty();
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return 16;
    }

    @SubscribeEvent
    private static void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new FluidHandlerItemStackSimple((Supplier)CoreItemDataComponents.FluidContainer, stack, 250), new ItemLike[]{MachinesContent.Item.Foil});
    }

    public int getColorOfItem(ItemStack stack, int index) {
        FluidStack fluid;
        if (index == 2 && !(fluid = ((SimpleFluidContent)stack.getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.EMPTY)).copy()).isEmpty()) {
            return IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)Utils.getClientLevel(), Utils.getClientPlayer().blockPosition());
        }
        return -1;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext ctx, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, ctx, components, tooltipFlag);
        FluidStack fluid = ((SimpleFluidContent)stack.getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.EMPTY)).copy();
        if (fluid.isEmpty()) {
            return;
        }
        DecimalFormat format = new DecimalFormat(",##0.###");
        MutableComponent component = Component.empty();
        component.append((Component)fluid.getHoverName().plainCopy().append(": ").withStyle(Style.EMPTY.withColor(0xFFCC66)));
        int amount = fluid.getAmount();
        CoreClientConfig.MeasuringUnit unit = (CoreClientConfig.MeasuringUnit)XyCore.ClientConfig.FluidUnit.get();
        if (amount >= 1000 && !tooltipFlag.isAdvanced()) {
            component.append((Component)Component.literal((String)String.format("%s %s", format.format((double)amount / 1000.0), unit.Unit)).withStyle(ChatFormatting.GRAY));
        } else {
            component.append((Component)Component.literal((String)String.format("%s %s", format.format(amount), unit.MilliUnit)).withStyle(ChatFormatting.GRAY));
        }
        components.add((Component)component);
    }

    public void handle(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() != MachinesContent.FluidTab.get()) {
            return;
        }
        event.accept(this.getDefaultInstance());
        BuiltInRegistries.FLUID.stream().filter(fluid -> fluid.isSource(fluid.defaultFluidState())).map(fluid -> new FluidStack(fluid, 250)).distinct().forEach(fluidStack -> {
            if (fluidStack.is(XyCraftTags.Fluids.UnstorableFluid.tag()) || fluidStack.is(Tags.Fluids.HIDDEN_FROM_RECIPE_VIEWERS)) {
                return;
            }
            ItemStack filledFoil = this.getDefaultInstance();
            SimpleFluidContent data = (SimpleFluidContent)filledFoil.getOrDefault((Supplier)CoreItemDataComponents.FluidContainer, (Object)SimpleFluidContent.copyOf((FluidStack)fluidStack));
            filledFoil.set((Supplier)CoreItemDataComponents.FluidContainer, (Object)data);
            event.accept(filledFoil);
        });
    }
}

