/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.capabilities;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.config.EnergyParadigm;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.items.EnergyHandlerItemStack;
import tv.soaryn.xycraft.machines.content.items.XynergyStorageItem;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public interface MachinesCapabilityRegistry {
    @SubscribeEvent
    public static void registerStorageCapabilities(RegisterCapabilitiesEvent event) {
        BuiltInRegistries.ITEM.forEach(item -> {
            MachinesCapabilityRegistry.registerModuleStorageItems(event, item);
            MachinesCapabilityRegistry.registerXynergyStorageItems(event, item);
        });
        event.registerItem(CoreCapabilities.TotemConsumable.ITEM, (stack, unused) -> player -> {
            stack.shrink(1);
            player.setHealth(1.0f);
            player.removeAllEffects();
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            player.level().broadcastEntityEvent((Entity)player, (byte)35);
            return true;
        }, new ItemLike[]{Items.TOTEM_OF_UNDYING});
    }

    private static void registerModuleStorageItems(RegisterCapabilitiesEvent event, Item registeredItem) {
    }

    private static void registerXynergyStorageItems(RegisterCapabilitiesEvent event, Item item) {
        if (!(item instanceof XynergyStorageItem)) {
            return;
        }
        event.registerItem(CoreCapabilities.XynergyStorage.ITEM, (stack, unused) -> new EnergyHandlerItemStack(stack), new ItemLike[]{item});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, unused) -> XyCore.ServerConfig.Paradigm.get() == EnergyParadigm.Neo ? new EnergyHandlerItemStack(stack) : null, new ItemLike[]{item});
    }
}

