/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.voidcontainer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.handlers.VoidEnergyHandler;
import tv.soaryn.xycraft.core.utils.handlers.VoidFluidHandler;
import tv.soaryn.xycraft.core.utils.handlers.VoidItemHandler;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class VoidContainerBlock
extends SidePartBlock.WithEntity
implements IColoredBlock,
EntityBlock,
ITooltipProvider.BlockDefault {
    public VoidContainerBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks(), Entity::new);
        this.registerSystem(MachinesSystems.Void);
        this.registerHasCapability();
    }

    public VoxelShape getDownShapeForBaking() {
        return Shapes.or((VoxelShape)VoidContainerBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)3.25, (double)12.0), (VoxelShape)VoidContainerBlock.box((double)4.8, (double)4.8, (double)4.8, (double)11.2, (double)11.2, (double)11.2));
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> VoidContainerBlock.isInaccessibleSide((Direction)context, (BlockState)state) ? null : new VoidItemHandler(blockEntity), new Block[]{MachinesContent.Block.VoidContainer.block()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, context) -> VoidContainerBlock.isInaccessibleSide((Direction)context, (BlockState)state) ? null : new VoidFluidHandler(blockEntity), new Block[]{MachinesContent.Block.VoidContainer.block()});
        event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, blockEntity, context) -> VoidContainerBlock.isInaccessibleSide((Direction)context, (BlockState)state) ? null : new VoidEnergyHandler(blockEntity), new Block[]{MachinesContent.Block.VoidContainer.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.VoidContainer.block()});
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return switch (index) {
            case 0, 1 -> 3342450;
            default -> -1;
        };
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return switch (index) {
            case 0, 1 -> 3342450;
            default -> -1;
        };
    }

    public static class Entity
    extends XyBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.VoidContainer.entity(), pos, state, new AttachmentType[0]);
        }
    }
}

