/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.XyCraftTags;

public class PipeBlockClientEvents {

    @EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    private static class Game {
        private Game() {
        }

        @SubscribeEvent
        private static void leftClickPipe(PlayerInteractEvent.LeftClickBlock event) {
            BlockState state = event.getLevel().getBlockState(event.getPos());
            if (!state.is(XyCraftTags.Blocks.MineableQuickRemove.tag())) {
                return;
            }
            if (state.is(XyCraftTags.Blocks.IncorrectForQuickRemove.tag())) {
                return;
            }
            if (!event.getEntity().getItemInHand(InteractionHand.MAIN_HAND).is(XyCraftTags.Items.QuickPickup.tag())) {
                return;
            }
            MultiPlayerGameMode gamemode = Minecraft.getInstance().gameMode;
            if (gamemode == null) {
                return;
            }
            gamemode.destroyDelay = (Integer)XyCore.ClientConfig.ActuatorPickupDelay.get();
        }
    }
}

