/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.collector;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.event.ItemEntityTickEvent;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.attachments.CollectorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.volumes.CollectorVolume;
import tv.soaryn.xycraft.machines.gui.CollectorMenu;
import tv.soaryn.xycraft.machines.network.CBCollectorAbsorbedPacket;

public class CollectorBlockEntity
extends XyBlockEntity
implements MenuProvider {
    public CollectorBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Block.Collector.entity(), pos, state, new AttachmentType[0]);
    }

    public static void onItemTick(ItemEntityTickEvent event) {
        Level level = event.getEntity().level();
        ItemEntity itemEntity = event.getEntity();
        if (level.isClientSide() || (level.getGameTime() + (long)itemEntity.getId() + 1L) % 10L != 0L) {
            return;
        }
        CollectorBlockEntity.absorbItem(level, itemEntity);
    }

    public static void onItemEntityForm(EntityJoinLevelEvent event) {
        Entity entity;
        Level level = event.getLevel();
        if (event.isCanceled() || level.isClientSide() || !((entity = event.getEntity()) instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (CollectorBlockEntity.absorbItem(level, itemEntity)) {
            itemEntity.setDefaultPickUpDelay();
            if (itemEntity.getItem().isEmpty()) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean absorbItem(Level level, ItemEntity itemEntity) {
        BlockPos pos = itemEntity.blockPosition();
        List<CollectorVolume> anchorVolumes = FastVolumeLookup.of((Level)level, CollectorVolume.class).find(pos).filter(anchor -> {
            BlockState state = level.getBlockState(anchor.getPos());
            return anchor.isStateValid(state) && state.getValue(MachineStateProperties.Status) == MachineStatusColors.Success;
        }).sorted(Comparator.comparingDouble(anchor -> anchor.pos().distSqr((Vec3i)pos))).toList();
        if (anchorVolumes.isEmpty()) {
            return false;
        }
        ItemStack entityItemstack = itemEntity.getItem();
        ItemStack remainder = entityItemstack.copy();
        ArrayList<BlockPos> acceptedVolumes = new ArrayList<BlockPos>();
        for (CollectorVolume anchor2 : anchorVolumes) {
            if (remainder.isEmpty()) break;
            BlockEntity blockEntity = level.getBlockEntity(anchor2.pos());
            if (!(blockEntity instanceof CollectorBlockEntity)) continue;
            CollectorBlockEntity collector = (CollectorBlockEntity)blockEntity;
            CollectorAttachment data = (CollectorAttachment)collector.getData(MachinesAttachments.Block.CollectorData);
            List<ItemStack> filter = data.Filter.copyToList().stream().filter(Predicate.not(ItemStack::isEmpty)).toList();
            boolean matched = filter.isEmpty();
            for (ItemStack itemStack : filter) {
                if (matched) break;
                matched = ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)remainder);
            }
            if (!matched) continue;
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)data.BufferItemHandler, (ItemStack)remainder.copy(), (boolean)false);
            collector.setChanged();
            acceptedVolumes.add(anchor2.pos());
        }
        if (!ItemStack.matches((ItemStack)entityItemstack, (ItemStack)remainder)) {
            itemEntity.setItem(remainder);
            for (BlockPos acceptedVolume : acceptedVolumes) {
                XyMachines.Network.broadcast(level, pos, (Packet.ClientBound)new CBCollectorAbsorbedPacket(itemEntity.position().toVector3f(), acceptedVolume));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"gui.xycraft_machines.collector");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        CollectorAttachment data = (CollectorAttachment)this.getData(MachinesAttachments.Block.CollectorData);
        return new CollectorMenu(windowId, playerInventory, (BlockEntity)this, data.FullInventory);
    }

    private void handleInventoryChange() {
        if (this.level == null) {
            return;
        }
        Direction direction = (Direction)this.getBlockState().getValue((Property)CoreStateProperties.StateDirection);
        BlockPos pos = this.getBlockPos();
        BlockPos posOfOther = pos.relative(direction);
        Direction opposite = direction.getOpposite();
        BlockState state = this.getBlockState();
        MachineStatusColors currentStatus = (MachineStatusColors)((Object)state.getValue(MachineStateProperties.Status));
        if (currentStatus == MachineStatusColors.Off) {
            return;
        }
        IItemHandler inventory = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, posOfOther, (Object)opposite);
        BlockState newState = (BlockState)state.setValue(MachineStateProperties.Status, (Comparable)((Object)(inventory != null ? MachineStatusColors.Success : MachineStatusColors.Idle)));
        this.level.setBlockAndUpdate(pos, newState);
        this.level.markAndNotifyBlock(pos, this.level.getChunkAt(pos), newState, newState, 3, 512);
    }
}

