/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.enums.BubbleColumnDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class IgnitionPlateBlock
extends ColoredBlock {
    public IgnitionPlateBlock(BlockBehaviour.Properties properties) {
        super((IColorSource)XyCraftColors.Red, properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false))).setValue((Property)CoreStateProperties.StateDirection, (Comparable)Direction.UP));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull Rotation direction) {
        return super.rotate(state, level, pos, direction);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (state.getValue((Property)CoreStateProperties.StateDirection) == Direction.UP && direction == Direction.UP && neighborState.is(Blocks.WATER)) {
            level.scheduleTick(pos, (Block)this, 20);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean isFlammable(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.getValue((Property)CoreStateProperties.Powered) != false && direction == state.getValue((Property)CoreStateProperties.StateDirection);
    }

    @SubscribeEvent
    private static void attachCapability(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.IgnitionPlate.block()});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CoreStateProperties.StateDirection});
        builder.add(new Property[]{CoreStateProperties.Powered});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ModifierKey.of((Player)ctx.getPlayer()) ? ctx.getClickedFace().getOpposite() : ctx.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.StateDirection, (Comparable)direction)).setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
    }

    public boolean isFireSource(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.getValue((Property)CoreStateProperties.Powered) != false && direction == state.getValue((Property)CoreStateProperties.StateDirection);
    }

    public boolean shouldCheckWeakPower(@NotNull BlockState state, @NotNull SignalGetter level, @NotNull BlockPos pos, @NotNull Direction side) {
        return false;
    }

    public boolean canConnectRedstone(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        return direction != ((Direction)state.getValue((Property)CoreStateProperties.StateDirection)).getOpposite();
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block neighbor, @NotNull BlockPos neighborPos, boolean p_60514_) {
        Direction dir = (Direction)state.getValue((Property)CoreStateProperties.StateDirection);
        boolean powered = (Boolean)state.getValue((Property)CoreStateProperties.Powered);
        BlockPos activationPos = pos.relative(dir);
        if (!level.isClientSide() && powered != level.hasNeighborSignal(pos)) {
            if (powered) {
                level.scheduleTick(pos, (Block)this, 2);
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(true)), 2);
                this.On(level.getBlockState(activationPos), level, activationPos, dir);
            }
        }
        if (!level.hasNeighborSignal(pos)) {
            state.setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
        }
    }

    public void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        Direction dir = (Direction)state.getValue((Property)CoreStateProperties.StateDirection);
        if (dir == Direction.UP) {
            BubbleColumnBlock.updateColumn((LevelAccessor)level, (BlockPos)pos.above(), (BlockState)state);
        }
        BlockPos activationPos = pos.relative(dir);
        if (((Boolean)state.getValue((Property)CoreStateProperties.Powered)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false)), 2);
            if (level.getBlockState(activationPos).is(BlockTags.FIRE)) {
                level.destroyBlock(activationPos, true);
            }
        }
        if (!level.hasNeighborSignal(pos)) {
            state.setValue((Property)CoreStateProperties.Powered, (Comparable)Boolean.valueOf(false));
        }
    }

    public void On(BlockState blockstate, @NotNull Level level, BlockPos blockpos, Direction direction) {
        if (!(CampfireBlock.canLight((BlockState)blockstate) || CandleBlock.canLight((BlockState)blockstate) || CandleCakeBlock.canLight((BlockState)blockstate))) {
            if (BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)blockpos, (Direction)direction)) {
                level.playSound(null, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
                BlockState fireState = BaseFireBlock.getState((BlockGetter)level, (BlockPos)blockpos);
                level.setBlock(blockpos, fireState, 11);
            }
        } else {
            level.playSound(null, blockpos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
        }
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean piston) {
        level.scheduleTick(pos, (Block)this, 4);
    }

    @NotNull
    public BubbleColumnDirection getBubbleColumnDirection(BlockState state) {
        if (state.getValue((Property)CoreStateProperties.StateDirection) != Direction.UP) {
            return BubbleColumnDirection.NONE;
        }
        return (Boolean)state.getValue((Property)CoreStateProperties.Powered) != false ? BubbleColumnDirection.DOWNWARD : BubbleColumnDirection.UPWARD;
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Entity entity) {
        if (state.getValue((Property)CoreStateProperties.StateDirection) == Direction.UP && ((Boolean)state.getValue((Property)CoreStateProperties.Powered)).booleanValue() && !entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }
}

