/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.balloonstake;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.items.XyBlockItem;
import tv.soaryn.xycraft.machines.content.attachments.BalloonStakeAttachment;
import tv.soaryn.xycraft.machines.content.blocks.balloonstake.BalloonStakeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;
import tv.soaryn.xycraft.machines.content.systems.BalloonStakeTickSystem;
import tv.soaryn.xycraft.machines.content.systems.MachinesSounds;

public class BalloonStakeBlock
extends SidePartBlock.WithEntity
implements EntityBlock,
ITooltipProvider.BlockDefault {
    public BalloonStakeBlock(BlockBehaviour.Properties properties) {
        super(properties.instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).destroyTime(2.0f).noOcclusion().randomTicks(), BalloonStakeBlockEntity::new);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(true)));
        this.registerSystem(MachinesSystems.BalloonStake);
    }

    public static XyBlockItem itemSupplier(Block block) {
        return new XyBlockItem(block, new Item.Properties().stacksTo(1));
    }

    public VoxelShape getDownShapeForBaking() {
        return BalloonStakeBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MachineStateProperties.Connected});
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onPlace(state, level, pos, oldState, moving);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BalloonStakeBlockEntity) {
            BalloonStakeBlockEntity stake = (BalloonStakeBlockEntity)blockEntity;
            BalloonStakeAttachment data = (BalloonStakeAttachment)stake.getData(MachinesAttachments.Block.BalloonData);
            if (data.getBoundId() == -1) {
                return;
            }
            Player player = data.getPlayer(level);
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                AttributeInstance creativeFlight = player2.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
                if (creativeFlight == null) {
                    return;
                }
                data.setIsBound(true);
                data.setPlayer((Player)player2);
                blockEntity.setChanged();
                if (!creativeFlight.hasModifier(BalloonStakeTickSystem.BalloonBoundID)) {
                    creativeFlight.addTransientModifier(BalloonStakeTickSystem.InsideField);
                }
                blockEntity.setChanged();
                float r = Mth.clamp((float)(level.getRandom().nextFloat() - 0.5f), (float)-0.01f, (float)0.1f);
                level.playSound(null, pos, (SoundEvent)MachinesSounds.BalloonInflate.value(), SoundSource.PLAYERS, 0.3f, 1.0f + r);
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        return (BlockState)state.setValue((Property)MachineStateProperties.Connected, (Comparable)Boolean.valueOf(!(ctx.getPlayer() instanceof FakePlayer)));
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        super.setPlacedBy(level, pos, state, entity, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (entity instanceof FakePlayer) {
            return;
        }
        if (blockEntity instanceof BalloonStakeBlockEntity) {
            BalloonStakeBlockEntity stake = (BalloonStakeBlockEntity)blockEntity;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerStatsCounter serverstatscounter = player.getStats();
                serverstatscounter.setValue((Player)player, Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST), 1000000);
                BalloonStakeAttachment data = (BalloonStakeAttachment)stake.getData(MachinesAttachments.Block.BalloonData);
                data.setBoundId(player.getId());
                blockEntity.setChanged();
            }
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_60519_) {
        Player player;
        BalloonStakeBlockEntity stake;
        BalloonStakeAttachment data;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BalloonStakeBlockEntity && (data = (BalloonStakeAttachment)(stake = (BalloonStakeBlockEntity)blockEntity).getData(MachinesAttachments.Block.BalloonData)).isBound() && (player = data.getPlayer(level)) != null) {
            float r = Mth.clamp((float)(level.getRandom().nextFloat() - 0.5f), (float)-0.01f, (float)0.1f);
            level.playSound(null, pos, (SoundEvent)MachinesSounds.BalloonPop.value(), SoundSource.PLAYERS, 0.5f, 1.0f + r);
        }
        super.onRemove(state, level, pos, newState, p_60519_);
    }
}

