/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments.level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.AttachmentUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.core.utils.serialization.CommonCodecs;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.blocks.FlareBlock;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.network.CBFlareRemovalPacket;
import tv.soaryn.xycraft.machines.network.CBFlareUpdatePacket;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class FlareMapLevelAttachment {
    private static final Codec<FlareMapLevelAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.tupleOf((Codec)BlockPos.CODEC, (Codec)Codec.INT, Object2IntOpenHashMap::new).fieldOf("flare_color").forGetter(FlareMapLevelAttachment::getColorMapping), (App)CodecUtils.tupleOf((Codec)CommonCodecs.ChunkPosCodec, (Codec)NeoForgeExtraCodecs.setOf((Codec)BlockPos.CODEC).xmap(ObjectArraySet::new, ObjectArraySet::new), Object2ObjectOpenHashMap::new).fieldOf("chunks").forGetter(FlareMapLevelAttachment::getChunkMapping)).apply((Applicative)builder, FlareMapLevelAttachment::new));
    public static final AttachmentType.Builder<FlareMapLevelAttachment> BUILDER = AttachmentUtils.createBuilder(FlareMapLevelAttachment::new, CODEC, (data, holder) -> {
        data.level = (Level)holder;
    });
    private Level level;
    private final Object2IntOpenHashMap<BlockPos> colorMap = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<ChunkPos, ObjectArraySet<BlockPos>> chunkMapping = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<BlockPos> breakMap = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<BlockPos, AABB> boundMapping = new Object2ObjectOpenHashMap();
    final AABB defaultBounds = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    private FlareMapLevelAttachment(IAttachmentHolder holder) {
        Level holderAsLevel;
        if (!(holder instanceof Level)) {
            throw new IllegalStateException("Trying to attach FlareAttachment on something other than a level: [%s]".formatted(holder.getClass().toString()));
        }
        this.level = holderAsLevel = (Level)holder;
    }

    private FlareMapLevelAttachment(Object2IntOpenHashMap<BlockPos> colors, Object2ObjectOpenHashMap<ChunkPos, ObjectArraySet<BlockPos>> chunks) {
        this.colorMap.putAll(colors);
        if (chunks != null) {
            this.chunkMapping.putAll(chunks);
        } else {
            colors.forEach((pos, integer) -> {
                ChunkPos chunk = new ChunkPos(pos);
                if (this.chunkMapping.containsKey((Object)chunk)) {
                    ObjectArraySet set = (ObjectArraySet)this.chunkMapping.get((Object)chunk);
                    set.add(pos);
                } else {
                    ObjectArraySet set = new ObjectArraySet();
                    set.add(pos);
                    this.chunkMapping.put((Object)chunk, (Object)set);
                }
            });
        }
    }

    public Object2ObjectOpenHashMap<ChunkPos, ObjectArraySet<BlockPos>> getChunkMapping() {
        return this.chunkMapping;
    }

    public Object2IntOpenHashMap<BlockPos> getColorMapping() {
        return this.colorMap;
    }

    public Object2IntMap.FastEntrySet<BlockPos> entrySet() {
        return this.colorMap.object2IntEntrySet();
    }

    public AABB getBounds(BlockPos pos) {
        return (AABB)this.boundMapping.getOrDefault((Object)pos, (Object)this.defaultBounds);
    }

    public void setFlare(BlockPos pos, int color) {
        if (!this.level.isClientSide()) {
            XyMachines.Network.broadcast(this.level, pos, (Packet.ClientBound)new CBFlareUpdatePacket(pos, color));
        }
        this.boundMapping.put((Object)pos, (Object)FlareBlock.box.bounds().move(pos));
        ChunkPos chunk = new ChunkPos(pos);
        if (this.chunkMapping.containsKey((Object)chunk)) {
            ObjectArraySet set = (ObjectArraySet)this.chunkMapping.get((Object)chunk);
            set.add((Object)pos);
        } else {
            ObjectArraySet set = new ObjectArraySet();
            set.add((Object)pos);
            this.chunkMapping.put((Object)chunk, (Object)set);
        }
        this.colorMap.put((Object)pos, color);
        this.breakMap.put((Object)pos, color);
    }

    public boolean hasFlare(BlockPos pos) {
        return this.colorMap.containsKey((Object)pos);
    }

    public void removeFlare(BlockPos pos) {
        if (!this.level.isClientSide()) {
            XyMachines.Network.broadcast(this.level, (Packet.ClientBound)new CBFlareRemovalPacket(pos));
        }
        this.boundMapping.remove((Object)pos);
        ChunkPos chunk = new ChunkPos(pos);
        this.chunkMapping.computeIfPresent((Object)chunk, (chunkPos, blockPos) -> {
            blockPos.remove((Object)pos);
            return blockPos;
        });
        this.colorMap.removeInt((Object)pos);
    }

    public int getColor(BlockPos pos) {
        return this.colorMap.getOrDefault((Object)pos, XyCraftColors.Blue.getColor());
    }

    public int getBreakColor(BlockPos pos) {
        return this.breakMap.getOrDefault((Object)pos, this.getColor(pos));
    }

    @SubscribeEvent
    public static void onChunkWatchWatch(ChunkWatchEvent.Sent event) {
        FlareMapLevelAttachment data = (FlareMapLevelAttachment)event.getLevel().getData(MachinesAttachments.Level.FlareColorMapData);
        ObjectArraySet blockSet = (ObjectArraySet)data.chunkMapping.get((Object)event.getPos());
        if (blockSet == null) {
            return;
        }
        blockSet.forEach(blockPos -> XyMachines.Network.send((Player)event.getPlayer(), (Packet.ClientBound)new CBFlareUpdatePacket((BlockPos)blockPos, data.colorMap.getInt(blockPos))));
    }
}

