/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jei.categories;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.ui.NineSlicedResource;
import tv.soaryn.xycraft.core.ui.oldwidget.ImageWidget;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.rules.FluidRuleGroup;
import tv.soaryn.xycraft.core.utils.rules.IRule;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.viewers.ExtractorViewerCommon;
import tv.soaryn.xycraft.machines.compat.viewers.jei.FluidBlockRenderer;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

public class ExtractorCategory
implements IRecipeCategory<RecipeHolder<ExtractorRecipe>> {
    public static final RecipeType<RecipeHolder<ExtractorRecipe>> Type = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)MachinesRecipeTypes.Extractor.type().get()));
    private final IDrawable _icon;
    private final IDrawableStatic _background;
    private final FluidBlockRenderer fluidRenderer;
    private static final DecimalFormat formatter = new DecimalFormat("#.##");

    public ExtractorCategory(IGuiHelper helper) {
        this._icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesContent.Block.Extractor.block()));
        this._background = helper.createBlankDrawable(140, 101);
        this.fluidRenderer = new FluidBlockRenderer();
    }

    public static void register(@NotNull IRecipeRegistration registration) {
        ExtractorViewerCommon.handleIntegration((items, fluids) -> {
            registration.addRecipes(Type, items);
            registration.addRecipes(Type, fluids);
        });
    }

    @NotNull
    public RecipeType<RecipeHolder<ExtractorRecipe>> getRecipeType() {
        return Type;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.xycraft.recipe.extractor");
    }

    @NotNull
    public IDrawable getBackground() {
        return this._background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this._icon;
    }

    public void draw(@NotNull RecipeHolder<ExtractorRecipe> holder, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        ImageWidget cube;
        ExtractorRecipe recipe = (ExtractorRecipe)holder.value();
        ImageWidget image2 = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_full.png"), 103.0f, 34.0f, 16.0f, 16.0f, -1429436382);
        ImageWidget image2Glow = new ImageWidget(null, XyMachines.resource("textures/gui/icons/arrow_glow.png"), 103.0f, 34.0f, 16.0f, 16.0f, 0x77FFFFFF);
        NineSlicedResource slotUi = new NineSlicedResource(XyCore.resource((String)"textures/gui/sliced/slot.png"));
        ImageWidget resultCube = cube = new ImageWidget(null, XyMachines.resource("textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -1);
        ImageWidget invalid = new ImageWidget(null, XyMachines.resource("textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -858993460);
        ImageWidget valid = new ImageWidget(null, XyMachines.resource("textures/gui/icons/generic_cube.png"), 0.0f, 0.0f, 16.0f, 16.0f, -866792363);
        PoseStack stack = graphics.pose();
        stack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        slotUi.render(stack, 30.0f, 18.0f, 21.0f, 21.0f, 1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.pushPose();
        stack.scale(0.8f, 0.8f, 0.8f);
        stack.mulPose(new Quaternionf().rotationZ(-1.5707964f));
        stack.translate(-64.0f, 42.0f, 0.0f);
        image2.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        image2Glow.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        stack.pushPose();
        stack.translate(92.0f, 50.0f, 10.0f);
        float scale = 1.0f;
        stack.scale(scale, scale, scale);
        stack.pushPose();
        stack.translate(12.0f, 0.0f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        stack.translate(-0.5 * (double)Minecraft.getInstance().font.width(Component.translatable((String)"jei.xycraft.recipe.extractor.directions").getString()), -24.0, 0.0);
        graphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.xycraft.recipe.extractor.directions"), 0, 0, 0xF0F0F0);
        stack.popPose();
        RenderSystem.enableDepthTest();
        int x = 12;
        float y = (float)x * 0.5f;
        stack.pushPose();
        cube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.DOWN) ? valid : invalid;
        stack.pushPose();
        stack.translate(0.0f, (float)(-x), 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.UP) ? valid : invalid;
        stack.pushPose();
        stack.translate(0.0f, (float)x, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.WEST) ? valid : invalid;
        stack.pushPose();
        stack.translate((float)(-x), -y, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.NORTH) ? valid : invalid;
        stack.pushPose();
        stack.translate((float)x, -y, -1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.EAST) ? valid : invalid;
        stack.pushPose();
        stack.translate((float)(-x), y, 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        resultCube = recipe.validDirections().contains(Direction.SOUTH) ? valid : invalid;
        stack.pushPose();
        stack.translate((float)x, y, 1.0f);
        resultCube.render(graphics, (int)mouseX, (int)mouseY, 0.0f);
        stack.popPose();
        stack.popPose();
        stack.pushPose();
        stack.translate(4.0f, 4.0f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MutableComponent time = Component.translatable((String)"jei.xycraft.recipe.general.time").append(": " + formatter.format((float)recipe.ticks() / 20.0f) + " ").append((Component)Component.translatable((String)"jei.xycraft.recipe.general.seconds"));
        graphics.drawString(Minecraft.getInstance().font, (Component)time, 0, 0, 0xF0F0F0);
        stack.popPose();
        stack.popPose();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull RecipeHolder<ExtractorRecipe> holder, @NotNull IFocusGroup focuses) {
        ExtractorRecipe recipe = (ExtractorRecipe)holder.value();
        if (recipe.catalyst().isPresent()) {
            this.buildIngredient(32, 78, builder, recipe.catalyst().get());
        }
        this.buildIngredient(32, 64, builder, recipe.target());
        int i = 0;
        int centerX = 32;
        int centerY = 64;
        float[] indices = new float[]{1.5707964f, 4.712389f, (float)Math.PI, 0.0f};
        for (IRule adj : recipe.adjacentRules()) {
            int x = 24;
            boolean y = false;
            float angle = indices[i++] + 0.7853982f;
            float c = Mth.cos((float)angle);
            float s = Mth.sin((float)angle) / 2.0f;
            float xRot = (float)x * c - (float)y * s;
            float yRot = (float)x * s + (float)y * c;
            this.buildIngredient((int)(xRot + (float)centerX), (int)(yRot + (float)centerY), builder, adj);
        }
        Optional<FluidType> waterlogged = recipe.waterloggedFluid();
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 32, 50).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MachinesContent.Block.Extractor.block()));
        if (waterlogged.isPresent()) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 32, 50).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)this.fluidRenderer).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)Fluids.WATER, 1000));
        }
        if (recipe.output().left().isPresent()) {
            FluidStack fluidStack = (FluidStack)recipe.output().left().get();
            builder.addSlot(RecipeIngredientRole.OUTPUT, 32, 20).setFluidRenderer(1L, false, 16, 16).addFluidStack(fluidStack.getFluid(), (long)fluidStack.getAmount(), fluidStack.getComponentsPatch());
        } else if (recipe.output().right().isPresent()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 32, 20).addItemStack((ItemStack)recipe.output().right().get());
        }
    }

    private void buildIngredient(int x, int y, @NotNull IRecipeLayoutBuilder builder, IRule rule) {
        Level level = Utils.getClientLevel();
        assert (level != null);
        if (!(rule instanceof FluidRuleGroup)) {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ExtractorViewerCommon.RuleToItems.get(rule));
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, x, y).setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)this.fluidRenderer).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, ExtractorViewerCommon.RuleToFluids.get(rule));
        }
    }
}

