/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.mekanism.content.blocks;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.recipes.RotaryRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.compat.mekanism.ChemicalCapabilityRegistry;
import tv.soaryn.xycraft.machines.compat.mekanism.DummyChemicalHandler;
import tv.soaryn.xycraft.machines.compat.mekanism.content.attachments.ChemicalAdapterAttachment;
import tv.soaryn.xycraft.machines.compat.mekanism.content.blocks.MekanismAttachments;
import tv.soaryn.xycraft.machines.compat.mekanism.content.blocks.MekanismContent;
import tv.soaryn.xycraft.machines.content.blocks.pipe.objects.DummyFluidHandler;

public class ChemicalAdapterBlock
extends SidePartBlock.WithEntity {
    private ChemicalAdapterBlock(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, XyBlockEntity> entity) {
        super(properties.noOcclusion(), entity);
        this.registerHasCapability();
    }

    public static ChemicalAdapterBlock evaporator(BlockBehaviour.Properties properties) {
        return new ChemicalAdapterBlock(properties, Entity::evaporator);
    }

    public static ChemicalAdapterBlock condenser(BlockBehaviour.Properties properties) {
        return new ChemicalAdapterBlock(properties, Entity::condenser);
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    public VoxelShape getDownShapeForBaking() {
        return ChemicalAdapterBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(ChemicalCapabilityRegistry.ChemicalCapability, (level, pos, state, blockEntity, context) -> {
            if (SidePartBlock.directionOf((BlockState)level.getBlockState(pos)).getOpposite() == context) {
                return new IChemicalHandler(){
                    final /* synthetic */ Direction val$context;
                    {
                        this.val$context = direction;
                    }

                    public int getChemicalTanks() {
                        return 1;
                    }

                    @NotNull
                    public ChemicalStack getChemicalInTank(int tank) {
                        return ChemicalStack.EMPTY;
                    }

                    public void setChemicalInTank(int tank, @NotNull ChemicalStack stack) {
                    }

                    public long getChemicalTankCapacity(int tank) {
                        return 1000000000L;
                    }

                    public boolean isValid(int tank, @NotNull ChemicalStack resource) {
                        if (blockEntity == null) {
                            return false;
                        }
                        Optional<RecipeHolder<RotaryRecipe>> holder = ((ChemicalAdapterAttachment)blockEntity.getData(MekanismAttachments.Block.ChemicalAdapterCache)).getRecipeFor(level, resource);
                        return holder.isPresent() && ((RotaryRecipe)holder.get().value()).hasChemicalToFluid();
                    }

                    @NotNull
                    public ChemicalStack insertChemical(int tank, @NotNull ChemicalStack resource, @NotNull Action action) {
                        if (blockEntity == null) {
                            return resource;
                        }
                        IFluidHandler cap = CapAccess.fluid((BlockEntity)blockEntity, (Direction)this.val$context.getOpposite());
                        if (cap == null) {
                            return resource;
                        }
                        Optional<RecipeHolder<RotaryRecipe>> holder = ((ChemicalAdapterAttachment)blockEntity.getData(MekanismAttachments.Block.ChemicalAdapterCache)).getRecipeFor(level, resource);
                        if (holder.isEmpty()) {
                            return resource;
                        }
                        RotaryRecipe recipe = (RotaryRecipe)holder.get().value();
                        if (!recipe.hasChemicalToFluid()) {
                            return resource;
                        }
                        FluidStack output = recipe.getFluidOutput(resource);
                        if (output.isEmpty()) {
                            return resource;
                        }
                        return resource.copyWithAmount(resource.getAmount() - (long)cap.fill(output.copyWithAmount(Math.min(MathUtils.toInt((long)resource.getAmount()), XyMachines.ServerConfig.MaxCondenserRate.getAsInt())), action.toFluidAction()));
                    }

                    @NotNull
                    public ChemicalStack extractChemical(int tank, long amount, @NotNull Action action) {
                        return ChemicalStack.EMPTY;
                    }
                };
            }
            return null;
        }, new Block[]{MekanismContent.Block.MekanicalCondenser.block()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (SidePartBlock.directionOf((BlockState)level.getBlockState(pos)).getOpposite() != context) {
                return null;
            }
            return new IFluidHandler(){
                final /* synthetic */ Direction val$context;
                {
                    this.val$context = direction;
                }

                public int getTanks() {
                    return 1;
                }

                @NotNull
                public FluidStack getFluidInTank(int tank) {
                    return FluidStack.EMPTY;
                }

                public int getTankCapacity(int tank) {
                    return 1000000000;
                }

                public boolean isFluidValid(int tank, @NotNull FluidStack resource) {
                    if (blockEntity == null) {
                        return false;
                    }
                    Optional<RecipeHolder<RotaryRecipe>> holder = ((ChemicalAdapterAttachment)blockEntity.getData(MekanismAttachments.Block.ChemicalAdapterCache)).getRecipeFor(level, resource);
                    return holder.isPresent() && ((RotaryRecipe)holder.get().value()).hasChemicalToFluid();
                }

                public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                    if (blockEntity == null) {
                        return 0;
                    }
                    IChemicalHandler cap = (IChemicalHandler)CapAccess.general((BlockEntity)blockEntity, (Direction)this.val$context.getOpposite(), MekanismAttachments.Block.AdjacentChemicalCapabilityCache);
                    if (cap == null) {
                        return 0;
                    }
                    Optional<RecipeHolder<RotaryRecipe>> holder = ((ChemicalAdapterAttachment)blockEntity.getData(MekanismAttachments.Block.ChemicalAdapterCache)).getRecipeFor(level, resource);
                    if (holder.isEmpty()) {
                        return 0;
                    }
                    RotaryRecipe recipe = (RotaryRecipe)holder.get().value();
                    if (!recipe.hasChemicalToFluid()) {
                        return 0;
                    }
                    ChemicalStack output = recipe.getChemicalOutput(resource);
                    if (output.isEmpty()) {
                        return 0;
                    }
                    int insertableAmount = Math.min(resource.getAmount(), XyMachines.ServerConfig.MaxEvaporatorRate.getAsInt());
                    ChemicalStack remainder = cap.insertChemical(output.copyWithAmount((long)insertableAmount), Action.fromFluidAction((IFluidHandler.FluidAction)action));
                    return MathUtils.toInt((long)((long)insertableAmount - remainder.getAmount()));
                }

                @NotNull
                public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                    return this.drain(0, action);
                }

                @NotNull
                public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        }, new Block[]{MekanismContent.Block.MekanicalEvaporator.block()});
        event.registerBlock(ChemicalCapabilityRegistry.ChemicalCapability, ChemicalAdapterBlock.dummyProvider(DummyChemicalHandler::new), new Block[]{MekanismContent.Block.MekanicalEvaporator.block()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, ChemicalAdapterBlock.dummyProvider(DummyFluidHandler::new), new Block[]{MekanismContent.Block.MekanicalCondenser.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MekanismContent.Block.MekanicalCondenser.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MekanismContent.Block.MekanicalEvaporator.block()});
    }

    private static <T> IBlockCapabilityProvider<T, @Nullable Direction> dummyProvider(Supplier<T> factory) {
        return (level, pos, state, blockEntity, context) -> SidePartBlock.directionOf((BlockState)level.getBlockState(pos)) == context ? factory.get() : null;
    }

    public static class Entity
    extends XyBlockEntity {
        public Entity(BlockEntityType entityType, BlockPos pos, BlockState state) {
            super(entityType, pos, state, new AttachmentType[0]);
        }

        public static Entity condenser(BlockPos pos, BlockState state) {
            return new Entity(MekanismContent.Block.MekanicalCondenser.entity(), pos, state);
        }

        public static Entity evaporator(BlockPos pos, BlockState state) {
            return new Entity(MekanismContent.Block.MekanicalEvaporator.entity(), pos, state);
        }
    }
}

