/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.owo.ui.base.BaseOwoTooltipComponent;
import io.wispforest.owo.ui.component.BoxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.Delta;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rearth.oracle.OracleClient;

@Mixin(value={GuiGraphics.class})
public class DrawContextMixin {
    @Inject(method={"renderTooltipInternal(Lnet/minecraft/client/gui/Font;Ljava/util/List;IILnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipPositioner;)V"}, at={@At(value="HEAD")})
    private void injectTooltipComponents(Font textRenderer, List<ClientTooltipComponent> components, int x, int y, ClientTooltipPositioner positioner, CallbackInfo ci, @Local(argsOnly=true) LocalRef<List<ClientTooltipComponent>> componentsRef) {
        if (OracleClient.tooltipStack == null) {
            return;
        }
        Item stackItem = OracleClient.tooltipStack.getItem();
        ResourceLocation stackId = BuiltInRegistries.ITEM.getKey((Object)stackItem);
        if (!OracleClient.ITEM_LINKS.containsKey(stackId)) {
            return;
        }
        OracleClient.tooltipStack = null;
        BaseOwoTooltipComponent<FlowLayout> separator = new BaseOwoTooltipComponent<FlowLayout>(this, () -> {
            FlowLayout container = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            BoxComponent box = Components.box((Sizing)Sizing.fixed((int)100), (Sizing)Sizing.fixed((int)1));
            box.margins(Insets.of((int)4, (int)4, (int)2, (int)2));
            box.color(new Color(0.5f, 0.5f, 0.5f));
            container.child((io.wispforest.owo.ui.core.Component)box);
            return container;
        }){};
        ArrayList<ClientTooltipComponent> modifiableComponents = new ArrayList<ClientTooltipComponent>(components);
        modifiableComponents.add((ClientTooltipComponent)separator);
        OracleClient.BookItemLink stackLink = OracleClient.ITEM_LINKS.get(stackId);
        MutableComponent tooltipText = Component.literal((String)"\ud83d\udcd5 ").append((Component)Component.literal((String)(stackLink.bookId() + ": ")).withStyle(ChatFormatting.ITALIC)).append((Component)Component.literal((String)stackLink.entryName()));
        ClientTooltipComponent tooltip = ClientTooltipComponent.create((FormattedCharSequence)tooltipText.withStyle(ChatFormatting.GRAY).getVisualOrderText());
        modifiableComponents.add(tooltip);
        if (Screen.hasAltDown()) {
            OracleClient.openEntryProgress += (float)Delta.compute((double)OracleClient.openEntryProgress, (double)1.25, (double)(Minecraft.getInstance().getTimer().getGameTimeDeltaTicks() * 0.125f));
            int progressSteps = 40;
            int progress = (int)(OracleClient.openEntryProgress * (float)progressSteps);
            progress = Math.clamp((long)progress, 0, 40);
            int missingSteps = progressSteps - progress;
            String progressText = "[" + "|".repeat(progress) + ".".repeat(missingSteps) + "]";
            ClientTooltipComponent altTooltip = ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)progressText).getVisualOrderText());
            modifiableComponents.add(altTooltip);
            if (OracleClient.openEntryProgress > 0.95f) {
                OracleClient.openScreen(stackLink.bookId(), stackLink.linkTarget(), Minecraft.getInstance().screen);
            }
        } else {
            ClientTooltipComponent altTooltip = ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)"Hold [ALT] to open").withStyle(ChatFormatting.GRAY).getVisualOrderText());
            modifiableComponents.add(altTooltip);
        }
        componentsRef.set(modifiableComponents);
    }
}

