/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import commoble.morered.wires.AbstractWireBlock;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class WireBlockItem
extends BlockItem {
    public WireBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction activatedFace;
        BlockPlaceContext blockItemContext = new BlockPlaceContext(context);
        BlockPos placePos = blockItemContext.getClickedPos();
        BlockPos activatedPos = context.getClickedPos();
        Level world = context.getLevel();
        BlockState activatedState = world.getBlockState(activatedPos);
        if (activatedState.isFaceSturdy((BlockGetter)world, activatedPos, activatedFace = context.getClickedFace())) {
            BlockState existingPlacePosState = world.getBlockState(placePos);
            Direction attachmentSide = activatedFace.getOpposite();
            BooleanProperty sideProperty = AbstractWireBlock.INTERIOR_FACES[attachmentSide.ordinal()];
            if (existingPlacePosState.getBlock() == this.getBlock() && existingPlacePosState.hasProperty((Property)sideProperty) && !((Boolean)existingPlacePosState.getValue((Property)sideProperty)).booleanValue()) {
                BlockState newState = (BlockState)existingPlacePosState.setValue((Property)sideProperty, (Comparable)Boolean.valueOf(true));
                if (!this.placeBlock(blockItemContext, newState)) {
                    return InteractionResult.FAIL;
                }
                ItemStack stack = context.getItemInHand();
                Player player = context.getPlayer();
                newState.getBlock().setPlacedBy(world, placePos, newState, (LivingEntity)player, stack);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, placePos, stack);
                }
                SoundType soundtype = newState.getSoundType((LevelReader)world, placePos, (Entity)player);
                world.playSound(player, placePos, this.getPlaceSound(newState, world, placePos, player), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                if (player == null || !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        return super.useOn(context);
    }
}

