/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;

public class PulseGateBlock
extends RedstonePlateBlock {
    public static final BooleanProperty INPUT_B = PlateBlockStateProperties.INPUT_B;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final InputSide[] INPUT_SIDES = new InputSide[]{InputSide.B};
    public static final int PULSE_DURATION = 2;

    public PulseGateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState baseState = this.defaultBlockState();
        this.registerDefaultState((BlockState)((BlockState)baseState.setValue((Property)INPUT_B, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{INPUT_B, POWERED});
    }

    @Override
    public InputSide[] getInputSides() {
        return INPUT_SIDES;
    }

    @Override
    public EnumSet<Direction> getOutputSides(Level level, BlockPos pos, BlockState state) {
        return EnumSet.of(PlateBlockStateProperties.getOutputDirection(state));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (((Boolean)state.getValue((Property)INPUT_B)).booleanValue()) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.hasInputPower(level, state, pos)) {
            level.scheduleTick(pos, (Block)this, 2);
        }
    }

    @Override
    @Deprecated
    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean oldHasInput = (Boolean)state.getValue((Property)INPUT_B);
        boolean newHasInput = InputSide.B.isBlockReceivingPower(worldIn, state, pos);
        if (!oldHasInput && newHasInput) {
            BlockState newState = (BlockState)((BlockState)state.setValue((Property)INPUT_B, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
            worldIn.setBlockAndUpdate(pos, newState);
            if (!worldIn.getBlockTicks().willTickThisTick(pos, (Object)this)) {
                worldIn.scheduleTick(pos, (Block)this, 2, TickPriority.HIGH);
            }
        } else if (oldHasInput && !newHasInput) {
            BlockState newState = (BlockState)state.setValue((Property)INPUT_B, (Comparable)Boolean.valueOf(false));
            worldIn.setBlockAndUpdate(pos, newState);
        }
    }

    @Deprecated
    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        boolean powered = (Boolean)state.getValue((Property)POWERED);
        Direction outputDirectionWhenPowered = PlateBlockStateProperties.getOutputDirection(state);
        return powered && sideOfAdjacentBlock.getOpposite() == outputDirectionWhenPowered ? 15 : 0;
    }

    public void tick(BlockState oldBlockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockState newBlockState = (BlockState)oldBlockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
        if (newBlockState != oldBlockState) {
            level.setBlockAndUpdate(pos, newBlockState);
        }
    }
}

