/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.jei;

import com.google.common.collect.ImmutableList;
import commoble.morered.MoreRed;
import commoble.morered.client.ClientProxy;
import commoble.morered.client.jei.SolderingCategory;
import commoble.morered.soldering.SolderingRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = MoreRed.getModRL("morered");
    @Nullable
    private SolderingCategory solderingCategory;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.solderingCategory = new SolderingCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.solderingCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.solderingCategory == null) {
            throw new NullPointerException("More Red's Soldering JEI category failed to register! Notify the More Red author for assistance https://github.com/Commoble/morered/issues");
        }
        registration.addRecipes(SolderingCategory.TYPE, JEIProxy.getSolderingRecipes().stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MoreRed.get().solderingTableBlock.get()), new RecipeType[]{SolderingCategory.TYPE});
    }

    public static List<RecipeHolder<SolderingRecipe>> getSolderingRecipes() {
        ClientLevel clientLevel = Minecraft.getInstance().level;
        if (clientLevel != null) {
            RecipeManager manager = clientLevel.getRecipeManager();
            return ClientProxy.getAllSolderingRecipes(manager, clientLevel.registryAccess());
        }
        return ImmutableList.of();
    }
}

