/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import commoble.morered.util.ConfigHelper;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public record ClientConfig(ModConfigSpec.ConfigValue<Boolean> showPlacementPreview, ModConfigSpec.ConfigValue<Double> previewPlacementOpacity) {
    public static ClientConfig INSTANCE;

    public static void initClientConfig() {
        INSTANCE = ConfigHelper.register("morered", ModConfig.Type.CLIENT, ClientConfig::create);
    }

    public static ClientConfig create(ModConfigSpec.Builder builder) {
        builder.push("Rendering");
        ModConfigSpec.BooleanValue showPlacementPreview = builder.comment("Render preview of plate blocks before placing them").translation("morered.showPlacementPreview").define("showPlacementPreview", true);
        ModConfigSpec.DoubleValue previewPlacementOpacity = builder.comment("Opacity of the render preview. Higher value = less transparent, lower = more transparent").translation("morered.showPlacementPreview").defineInRange("previewPlacementOpacity", 0.4, 0.0, 1.0);
        builder.pop();
        return new ClientConfig((ModConfigSpec.ConfigValue<Boolean>)showPlacementPreview, (ModConfigSpec.ConfigValue<Double>)previewPlacementOpacity);
    }
}

