/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.morered.MoreRed;
import commoble.morered.client.ExtraRenderTypes;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WireSpoolItem;
import java.util.Set;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BundledCablePostRenderer
implements BlockEntityRenderer<WirePostBlockEntity> {
    public static final RenderType CABLE_RENDER_TYPE = ExtraRenderTypes.CABLE_RENDER_TYPE;
    public static final Material MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, MoreRed.getModRL("block/bundled_network_cable"));
    public static final float[] REDS = new float[]{0.71f, 0.31f, 0.19f};
    public static final float[] GREENS = new float[]{0.19f, 0.48f, 0.29f};
    public static final float[] BLUES = new float[]{0.12f, 0.16f, 0.66f};

    public BundledCablePostRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WirePostBlockEntity post, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite sprite = MATERIAL.sprite();
        float totalMinU = sprite.getU0();
        float totalMinV = sprite.getV0();
        float totalMaxU = sprite.getU1();
        float totalMaxV = sprite.getV1();
        float texWidth = totalMaxU - totalMinU;
        float texHeight = totalMaxV - totalMinV;
        float quadStartU = 0.6875f * texWidth + totalMinU;
        float quadEndU = 0.8125f * texWidth + totalMinU;
        float quadStartV = 0.375f * texHeight + totalMinV;
        float quadEndV = 0.75f * texHeight + totalMinV;
        BlockPos postPos = post.getBlockPos();
        Vec3 postVector = Vec3.atCenterOf((Vec3i)postPos);
        Set<BlockPos> connections = post.getRemoteConnections();
        Level world = post.getLevel();
        VertexConsumer vertexBuilder = buffer.getBuffer(ExtraRenderTypes.CABLE_RENDER_TYPE);
        for (BlockPos connectionPos : connections) {
            int endY;
            int startY = postPos.getY();
            if (startY >= (endY = connectionPos.getY()) && (startY != endY || postPos.hashCode() >= connectionPos.hashCode())) continue;
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, postVector, Vec3.atCenterOf((Vec3i)connectionPos), postPos, connectionPos, quadStartU, quadEndU, quadStartV, quadEndV);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        for (InteractionHand hand : InteractionHand.values()) {
            float eyeHeight;
            double handZ;
            double handY;
            double handX;
            BlockPos positionOfCurrentPostOfPlayer;
            ItemStack stack = player.getItemInHand(hand);
            if (!(stack.getItem() instanceof WireSpoolItem) || (positionOfCurrentPostOfPlayer = (BlockPos)stack.get((DataComponentType)MoreRed.get().spooledPostComponent.get())) == null) continue;
            EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
            if (!positionOfCurrentPostOfPlayer.equals((Object)postPos)) continue;
            Vec3 vectorOfCurrentPostOfPlayer = Vec3.atCenterOf((Vec3i)positionOfCurrentPostOfPlayer);
            int handSideID = -(hand == InteractionHand.MAIN_HAND ? -1 : 1) * (player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1);
            float swingProgress = player.getAttackAnim(partialTicks);
            float swingZ = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
            float playerAngle = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double playerAngleX = Mth.sin((float)playerAngle);
            double playerAngleZ = Mth.cos((float)playerAngle);
            double handOffset = (double)handSideID * 0.35;
            if (renderManager.options == null || renderManager.options.getCameraType() == CameraType.FIRST_PERSON) {
                double fov = ((Integer)renderManager.options.fov().get()).intValue();
                Vec3 handVector = new Vec3(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                handVector = handVector.xRot(-Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()) * ((float)Math.PI / 180));
                handVector = handVector.yRot(-Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()) * ((float)Math.PI / 180));
                handVector = handVector.yRot(swingZ * 0.5f);
                handVector = handVector.xRot(-swingZ * 0.7f);
                handX = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + handVector.x;
                handY = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + handVector.y;
                handZ = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + handVector.z;
                eyeHeight = player.getEyeHeight();
            } else {
                handX = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                handY = -0.2 + player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTicks - 0.45;
                handZ = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                eyeHeight = player.isCrouching() ? -0.1875f : 0.0f;
            }
            Vec3 renderPlayerVec = new Vec3(handX, handY + (double)eyeHeight, handZ);
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, vectorOfCurrentPostOfPlayer, renderPlayerVec, postPos, player.blockPosition(), quadStartU, quadEndU, quadStartV, quadEndV);
        }
    }

    private void renderConnection(WirePostBlockEntity post, Level level, float partialTicks, PoseStack matrices, VertexConsumer vertexBuilder, Vec3 startVec, Vec3 endVec, BlockPos startPos, BlockPos endPos, float minU, float maxU, float minV, float maxV) {
        matrices.pushPose();
        boolean translateSwap = false;
        if (startVec.y() > endVec.y()) {
            Vec3 swap = startVec;
            startVec = endVec;
            endVec = swap;
            float swapF = minU;
            minU = maxU;
            maxU = swapF;
            swapF = minV;
            minV = maxV;
            maxV = swapF;
            translateSwap = true;
        }
        matrices.translate(0.5, 0.5, 0.5);
        double startX = startVec.x();
        double startY = startVec.y();
        double startZ = startVec.z();
        double endX = endVec.x();
        double endY = endVec.y();
        double endZ = endVec.z();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            matrices.translate(-dx, -dy, -dz);
        }
        if (startY <= endY) {
            Vec3[] pointList = SlackInterpolator.getInterpolatedDifferences(endVec.subtract(startVec));
            int points = pointList.length;
            int lines = points - 1;
            float cableWidth = 0.1f;
            Matrix4f lastMatrix = matrices.last().pose();
            float offsetScale = 0.5f * cableWidth * (float)Mth.fastInvSqrt((double)(dx * dx + dz * dz));
            float xOffset = dz * offsetScale;
            float zOffset = dx * offsetScale;
            int startBlockLight = level.getBrightness(LightLayer.BLOCK, startPos);
            int endBlockLight = level.getBrightness(LightLayer.BLOCK, endPos);
            int startSkyLight = level.getBrightness(LightLayer.SKY, startPos);
            int endSkyLight = level.getBrightness(LightLayer.SKY, endPos);
            float maxLerpFactor = (float)lines - 1.0f;
            for (int segmentIndex = 0; segmentIndex < lines; ++segmentIndex) {
                Vec3 firstPoint = pointList[segmentIndex];
                Vec3 secondPoint = pointList[segmentIndex + 1];
                float lerpFactor = (float)segmentIndex / maxLerpFactor;
                int lerpedBlockLight = (int)Mth.lerp((float)lerpFactor, (float)startBlockLight, (float)endBlockLight);
                int lerpedSkyLight = (int)Mth.lerp((float)lerpFactor, (float)startSkyLight, (float)endSkyLight);
                int packedLight = LightTexture.pack((int)lerpedBlockLight, (int)lerpedSkyLight);
                float x0 = (float)firstPoint.x;
                float y0 = (float)firstPoint.y;
                float z0 = (float)firstPoint.z;
                float x1 = (float)secondPoint.x;
                float y1 = (float)secondPoint.y;
                float z1 = (float)secondPoint.z;
                int secondSegmentIndex = segmentIndex + 1;
                if (xOffset == 0.0f && zOffset == 0.0f) {
                    float width = cableWidth * 0.5f;
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, cableWidth, segmentIndex, false, width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, cableWidth, secondSegmentIndex, true, width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, 0.0f, segmentIndex, false, -width, width, minU, maxU, minV, maxV);
                    BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, 0.0f, secondSegmentIndex, true, -width, width, minU, maxU, minV, maxV);
                    continue;
                }
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, cableWidth, segmentIndex, false, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, cableWidth, secondSegmentIndex, true, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x0, y0, z0, cableWidth, 0.0f, segmentIndex, false, xOffset, zOffset, minU, maxU, minV, maxV);
                BundledCablePostRenderer.addVertexPair(vertexBuilder, lastMatrix, packedLight, x1, y1, z1, cableWidth, 0.0f, secondSegmentIndex, true, xOffset, zOffset, minU, maxU, minV, maxV);
            }
        }
        matrices.popPose();
    }

    public boolean shouldRenderOffScreen(WirePostBlockEntity te) {
        return true;
    }

    public AABB getRenderBoundingBox(WirePostBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }

    public static void addVertexPair(VertexConsumer vertexBuilder, Matrix4f lastMatrix, int packedLight, float x, float y, float z, float cableWidth, float cableWidthOrZero, int segmentIndex, boolean secondVertexPairForQuad, float xOffset, float zOffset, float minU, float maxU, float minV, float maxV) {
        if (!secondVertexPairForQuad) {
            vertexBuilder.addVertex(lastMatrix, x + xOffset, y + cableWidth - cableWidthOrZero, z - zOffset).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU, minV).setLight(packedLight);
            vertexBuilder.addVertex(lastMatrix, x - xOffset, y + cableWidthOrZero, z + zOffset).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(minU, maxV).setLight(packedLight);
        } else {
            vertexBuilder.addVertex(lastMatrix, x - xOffset, y + cableWidthOrZero, z + zOffset).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(maxU, maxV).setLight(packedLight);
            vertexBuilder.addVertex(lastMatrix, x + xOffset, y + cableWidth - cableWidthOrZero, z - zOffset).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(maxU, minV).setLight(packedLight);
        }
    }
}

