/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.bitwise_logic;

import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.plate_blocks.PlateBlock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.neoforged.neoforge.common.Tags;

public abstract class BitwiseLogicPlateBlock
extends PlateBlock
implements EntityBlock {
    public static final int TICK_DELAY = 1;
    public static final VoxelShape[] DOUBLE_PLATE_SHAPES_BY_DIRECTION = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final ChanneledPowerSupplier NO_POWER_SUPPLIER = (world, pos, state, dir, channel) -> 0;

    protected abstract void updatePower(Level var1, BlockPos var2, BlockState var3);

    public abstract boolean canConnectToAdjacentCable(@Nonnull BlockGetter var1, @Nonnull BlockPos var2, @Nonnull BlockState var3, @Nonnull BlockPos var4, @Nonnull BlockState var5, @Nonnull Direction var6, @Nonnull Direction var7);

    public BitwiseLogicPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().bitwiseLogicGateBeType.get()).create(pos, state);
    }

    @Override
    @Deprecated
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.hasProperty((Property)ATTACHMENT_DIRECTION)) {
            return DOUBLE_PLATE_SHAPES_BY_DIRECTION[((Direction)state.getValue((Property)ATTACHMENT_DIRECTION)).ordinal()];
        }
        return DOUBLE_PLATE_SHAPES_BY_DIRECTION[0];
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.scheduleTick(pos, (Block)this, 1);
    }

    protected void onPlace(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onPlace(newState, level, pos, newState, isMoving);
        level.invalidateCapabilities(pos);
    }

    public void onNeighborChange(BlockState thisState, LevelReader levelReader, BlockPos thisPos, BlockPos neighborPos) {
        super.onNeighborChange(thisState, levelReader, thisPos, neighborPos);
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            level.scheduleTick(thisPos, (Block)this, 1, TickPriority.HIGH);
        }
    }

    public void tick(BlockState oldBlockState, ServerLevel level, BlockPos pos, RandomSource rand) {
        this.updatePower((Level)level, pos, oldBlockState);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isPlayerHoldingStick = stack.is(Tags.Items.RODS_WOODEN);
        if (isPlayerHoldingStick && !level.isClientSide) {
            int newRotation = ((Integer)state.getValue((Property)ROTATION) + 1) % 4;
            BlockState newState = (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotation));
            level.setBlockAndUpdate(pos, newState);
        }
        return isPlayerHoldingStick ? ItemInteractionResult.SUCCESS : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }
}

