/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.api.internal;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.WireVoxelHelpers;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class DefaultWireProperties {
    public static final VoxelShape[] SMALL_NODE_SHAPES = WireVoxelHelpers.makeNodeShapes(1, 2);
    public static final WireConnector DEFAULT_WIRE_CONNECTOR = DefaultWireProperties::canGenericBlockConnectToWire;
    public static final ExpandedPowerSupplier DEFAULT_EXPANDED_POWER_SUPPLIER = DefaultWireProperties::getDefaultExpandedPower;
    public static final WireConnector DEFAULT_CABLE_CONNECTOR = DefaultWireProperties::canGenericBlockConnectToCable;
    public static final ChanneledPowerSupplier NO_POWER_SUPPLIER = (theWorld, pos, state, face, channel) -> 0;

    private static boolean canGenericBlockConnectToWire(BlockGetter world, BlockPos thisNeighborPos, BlockState thisNeighborState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        Block neighborBlock = thisNeighborState.getBlock();
        if (neighborBlock instanceof LeverBlock || neighborBlock instanceof ButtonBlock) {
            AttachFace attachFace = (AttachFace)thisNeighborState.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE);
            return attachFace == AttachFace.FLOOR && wireFace == Direction.DOWN || attachFace == AttachFace.CEILING && wireFace == Direction.UP || attachFace == AttachFace.WALL && ((Direction)thisNeighborState.getValue((Property)HorizontalDirectionalBlock.FACING)).getOpposite() == wireFace;
        }
        if (neighborBlock instanceof RedstoneWallTorchBlock) {
            return wireFace == ((Direction)thisNeighborState.getValue((Property)RedstoneWallTorchBlock.FACING)).getOpposite();
        }
        if (neighborBlock instanceof RedstoneTorchBlock || neighborBlock instanceof DetectorRailBlock || thisNeighborState.is(BlockTags.PRESSURE_PLATES)) {
            return wireFace == Direction.DOWN;
        }
        if (neighborBlock instanceof LightningRodBlock) {
            return wireFace == ((Direction)thisNeighborState.getValue((Property)LightningRodBlock.FACING)).getOpposite();
        }
        if (thisNeighborState.is(Tags.Blocks.CHESTS_TRAPPED)) {
            return true;
        }
        if (thisNeighborState.is(BlockTags.PRESSURE_PLATES)) {
            return wireFace == Direction.DOWN;
        }
        if (!thisNeighborState.canRedstoneConnectTo(world, wirePos, directionToWire.getOpposite())) {
            return false;
        }
        VoxelShape wireTestShape = SMALL_NODE_SHAPES[wireFace.ordinal()];
        VoxelShape neighborShape = thisNeighborState.getBlockSupportShape(world, thisNeighborPos);
        VoxelShape projectedNeighborShape = neighborShape.getFaceShape(directionToWire);
        return !Shapes.joinIsNotEmpty((VoxelShape)projectedNeighborShape, (VoxelShape)wireTestShape, (BooleanOp)BooleanOp.ONLY_SECOND);
    }

    public static boolean isRedstoneWireConnectable(BlockGetter world, BlockPos redstonePos, BlockState redstoneState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        return wireFace == Direction.DOWN && directionToWire.getAxis() != Direction.Axis.Y;
    }

    private static int getDefaultExpandedPower(@Nonnull Level world, @Nonnull BlockPos thisPos, @Nonnull BlockState thisState, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nonnull Direction wireFace, @Nonnull Direction directionToThis) {
        return thisState.getSignal((BlockGetter)world, thisPos, directionToThis) * 2;
    }

    private static boolean canGenericBlockConnectToCable(BlockGetter world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        return false;
    }
}

