/*
 * Decompiled with CFR 0.152.
 */
package com.thevortex.potionsmaster.render.util.xray;

import com.thevortex.potionsmaster.PotionsMaster;
import com.thevortex.potionsmaster.render.util.BlockData;
import com.thevortex.potionsmaster.render.util.BlockInfo;
import com.thevortex.potionsmaster.render.util.BlockStore;
import com.thevortex.potionsmaster.render.util.WorldRegion;
import com.thevortex.potionsmaster.render.util.xray.Controller;
import com.thevortex.potionsmaster.render.util.xray.Render;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class RenderEnqueue
implements Runnable {
    private final WorldRegion box;

    public RenderEnqueue(WorldRegion region) {
        this.box = region;
    }

    public static void checkBlock(BlockPos pos, BlockState state, boolean add) {
        if (!Controller.drawOres() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        String defaultState = state.getBlock().defaultBlockState().toString();
        if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
            if (!add) {
                Render.ores.remove(new BlockInfo((Vec3i)pos, 0, 0.0));
                return;
            }
            BlockData data = null;
            if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
                data = Controller.getBlockStore().getStore().get(defaultState);
            }
            if (data == null) {
                return;
            }
            double alpha = Math.max(0.0, ((double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) / (double)Controller.getRadius() * 255.0);
            Render.ores.add(new BlockInfo(new Vec3i(pos.getX(), pos.getY(), pos.getZ()), data.getColor(), alpha));
        }
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty() && !Render.ores.isEmpty()) {
            Render.ores.clear();
        }
        Level world = PotionsMaster.proxy.getClientPlayer().level();
        LocalPlayer player = PotionsMaster.proxy.getClientPlayer();
        ArrayList<BlockInfo> renderQueue = new ArrayList<BlockInfo>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.hasChunk(chunkX, chunkZ)) continue;
                LevelChunk chunk = world.getChunk(chunkX, chunkZ);
                LevelChunkSection[] extendsList = chunk.getSections();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    LevelChunkSection ebs = extendsList[curExtend + (Math.abs(chunk.getMinBuildHeight()) >> 4)];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                BlockState currentState = ebs.getBlockState(i, j, k);
                                Optional<TagKey> firstTag = currentState.getTags().filter(tag -> tag.toString().contains("ores/")).findAny();
                                if (!firstTag.isPresent()) continue;
                                TagKey block = firstTag.get();
                                for (BlockData data : PotionsMaster.blockStore.getStore().values()) {
                                    if (!block.location().toString().contains(data.getoreTag())) continue;
                                    double alpha = Math.max(0.0, (double)Controller.getRadius() - PotionsMaster.proxy.getClientPlayer().distanceToSqr((double)(x + i), (double)(y + j), (double)(z + k)) / (double)(Controller.getRadius() / 2));
                                    BlockStore.BlockDataWithUUID dataWithUUID = PotionsMaster.blockStore.getStoreByReference(data.getoreTag());
                                    if (dataWithUUID.getBlockData() == null || !dataWithUUID.getBlockData().isDrawing()) continue;
                                    renderQueue.add(new BlockInfo(x + i, y + j, z + k, dataWithUUID.getBlockData().getColor(), 1.0));
                                }
                            }
                        }
                    }
                }
            }
        }
        renderQueue.sort((t, t1) -> Double.compare(t1.distSqr(new Vec3i(player.getBlockX(), player.getBlockY(), player.getBlockZ())), t.distSqr(new Vec3i(player.getBlockX(), player.getBlockY(), player.getBlockZ()))));
        Render.ores.clear();
        Render.ores.addAll(renderQueue);
    }
}

