/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.Config;
import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationContainer;
import com.direwolf20.charginggadgets.capabilities.ChargerEnergyStorage;
import com.direwolf20.charginggadgets.capabilities.ChargerItemHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ChargingStationTile
extends BlockEntity
implements MenuProvider {
    private int counter = 0;
    private int maxBurn = 0;
    public ChargerEnergyStorage energyStorage;
    public ChargerItemHandler inventory = new ChargerItemHandler(this);
    public final ContainerData chargingStationData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ChargingStationTile.this.energyStorage.getEnergyStored() / 32;
                case 1 -> ChargingStationTile.this.energyStorage.getMaxEnergyStored() / 32;
                case 2 -> ChargingStationTile.this.counter;
                case 3 -> ChargingStationTile.this.maxBurn;
                default -> throw new IllegalArgumentException("Invalid index: " + index);
            };
        }

        public void set(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int getCount() {
            return 4;
        }
    };

    public ChargingStationTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.CHARGING_STATION_TILE.get(), pos, state);
        this.energyStorage = new ChargerEnergyStorage(this, 0, (Integer)Config.GENERAL.chargerMaxPower.get());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        assert (this.level != null);
        return new ChargingStationContainer(this, this.chargingStationData, i, playerInventory, this.inventory);
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos blockPos, BlockState state, T t) {
        if (t instanceof ChargingStationTile) {
            ChargingStationTile entity = (ChargingStationTile)t;
            entity.tryBurn();
            ItemStack stack = entity.inventory.getStackInSlot(Slots.CHARGE.id);
            if (!stack.isEmpty()) {
                entity.chargeItem(stack);
            }
        }
    }

    private void chargeItem(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return;
        }
        if (!this.isChargingItem(energy)) {
            return;
        }
        int energyRemoved = energy.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), 2500), false);
        this.energyStorage.consumeEnergy(energyRemoved, false);
    }

    public boolean isChargingItem(IEnergyStorage energy) {
        return energy.getEnergyStored() >= 0 && energy.receiveEnergy(energy.getEnergyStored(), true) >= 0;
    }

    private void tryBurn() {
        boolean canInsertEnergy;
        if (this.level == null) {
            return;
        }
        boolean bl = canInsertEnergy = this.energyStorage.receiveEnergy(625, true) > 0;
        if (this.counter > 0 && canInsertEnergy) {
            this.burn(this.energyStorage);
        } else if (canInsertEnergy && this.initBurn()) {
            this.burn(this.energyStorage);
        }
    }

    private void burn(IEnergyStorage energyStorage) {
        energyStorage.receiveEnergy(625, false);
        --this.counter;
        if (this.counter == 0) {
            this.maxBurn = 0;
            this.initBurn();
        }
    }

    private boolean initBurn() {
        ItemStack stack = this.inventory.getStackInSlot(Slots.FUEL.id);
        int burnTime = stack.getBurnTime(RecipeType.SMELTING);
        if (burnTime > 0) {
            ItemStack fuelStack = this.inventory.getStackInSlot(Slots.FUEL.id);
            if (fuelStack.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(Slots.FUEL.id, fuelStack.getCraftingRemainingItem());
            } else {
                fuelStack.shrink(1);
            }
            this.setChanged();
            this.maxBurn = this.counter = (int)Math.floor(burnTime) / 50;
            return true;
        }
        return false;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.inventory.deserializeNBT(provider, compound.getCompound("inv"));
        this.energyStorage.deserializeNBT(provider, compound.getCompound("energy"));
        this.counter = compound.getInt("counter");
        this.maxBurn = compound.getInt("maxburn");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inv", (Tag)this.inventory.serializeNBT(provider));
        compound.put("energy", (Tag)this.energyStorage.serializeNBT(provider));
        compound.putInt("counter", this.counter);
        compound.putInt("maxburn", this.maxBurn);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public Component getDisplayName() {
        return Component.literal((String)"Charging Station Tile");
    }

    public static enum Slots {
        FUEL(0),
        CHARGE(1);

        int id;

        private Slots(int number) {
            this.id = number;
        }

        public int getId() {
            return this.id;
        }
    }
}

