/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TurbineRotorBearingBlock
extends GenericDeviceBlock<MultiblockTurbine, ITurbinePartType> {
    public TurbineRotorBearingBlock(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        super(properties);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos position, RandomSource random) {
        if (((Boolean)Config.CLIENT.disableTurbineParticles.get()).booleanValue()) {
            return;
        }
        TurbineRotorBearingBlock.getTile((BlockGetter)world, position).ifPresent(bearing -> this.animateTick((TurbineRotorBearingEntity)((Object)bearing), world, position, random));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(TurbineRotorBearingEntity bearing, Level world, BlockPos pos, RandomSource random) {
        bearing.getMultiblockController().filter(turbine -> !turbine.isInteriorInvisible()).filter(MultiblockTurbine::isAssembledAndActive).ifPresent(turbine -> turbine.forBoundingBoxCoordinates((min, max) -> {
            int numParticles = Math.min(20, Math.max(1, turbine.getFluidConsumedLastTick() / 40));
            BlockPos minCoord = min.offset(1, 1, 1);
            BlockPos maxCoord = max.offset(-1, -1, -1);
            Direction inwardsDir = bearing.getOutwardDirection().map(Direction::getOpposite).orElse(Direction.UP);
            int offsetX = inwardsDir.getStepX();
            int offsetY = inwardsDir.getStepY();
            int offsetZ = inwardsDir.getStepZ();
            SimpleParticleType particle = ParticleTypes.CLOUD;
            int minX = minCoord.getX();
            int minY = minCoord.getY();
            int minZ = minCoord.getZ();
            int maxX = maxCoord.getX();
            int maxY = maxCoord.getY();
            int maxZ = maxCoord.getZ();
            if (offsetX != 0) {
                minX = maxX = pos.getX() + offsetX;
            } else if (offsetY != 0) {
                minY = maxY = pos.getY() + offsetY;
            } else {
                minZ = maxZ = pos.getZ() + offsetZ;
            }
            for (int i = 0; i < numParticles; ++i) {
                int particleX = minX + (int)(random.nextFloat() * (float)(maxX - minX + 1));
                int particleY = minY + (int)(random.nextFloat() * (float)(maxY - minY + 1));
                int particleZ = minZ + (int)(random.nextFloat() * (float)(maxZ - minZ + 1));
                WorldHelper.spawnVanillaParticles((Level)world, (ParticleOptions)particle, (int)1, (int)numParticles, (int)particleX, (int)particleY, (int)particleZ, (int)0, (int)0, (int)0);
            }
        }));
    }

    private static Optional<TurbineRotorBearingEntity> getTile(BlockGetter world, BlockPos position) {
        return WorldHelper.getTile((BlockGetter)world, (BlockPos)position).filter(te -> te instanceof TurbineRotorBearingEntity).map(te -> (TurbineRotorBearingEntity)((Object)te));
    }
}

