/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.container.FluidPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPortHandler;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ReactorFluidPortEntity
extends AbstractReactorEntity
implements IFluidPort,
INeighborChangeListener,
MenuProvider {
    private final IFluidPortHandler _handler;
    private IoDirection _direction;

    public ReactorFluidPortEntity(FluidPortType type, IoMode mode, BlockEntityType<?> entityType, BlockPos position, BlockState blockState) {
        super(entityType, position, blockState);
        this._handler = FluidPortType.create(type, mode, this);
        this.setIoDirection(IoDirection.Input);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    public IFluidPortHandler getFluidPortHandler() {
        return this._handler;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.getFluidPortHandler().onPortChanged();
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.getFluidPortHandler().onPortChanged();
        this.requestClientRenderUpdate();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.executeOnController(MultiblockReactor::onFluidPortChanged);
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.setChanged();
        }, () -> ((ReactorFluidPortEntity)this).markForRenderUpdate());
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        this.setIoDirection(IoDirection.read((CompoundTag)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        IoDirection.write((CompoundTag)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new FluidPortContainer<MultiblockReactor, IMultiblockReactorVariant, ReactorFluidPortEntity>(windowId, Content.ContainerTypes.REACTOR_FLUIDPORT.get(), inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getFluidPortHandler().isConnected() ? 1 : 0;
        return this.getIoDirection().isInput() ? connectedOffset : 2 + connectedOffset;
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        IReactorPartType partType = (IReactorPartType)this.getPartTypeOrDefault((IMultiblockPartType)ReactorPartType.Casing);
        return (ReactorPartType.ActiveFluidPortForge == partType || ReactorPartType.PassiveFluidPortForge == partType) && this.isMachineAssembled();
    }

    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onAttached(MultiblockReactor newController) {
        super.onAttached((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onAssimilated(MultiblockReactor newController) {
        super.onAssimilated((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onDetached(MultiblockReactor oldController) {
        super.onDetached((IMultiblockController)oldController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    private IFluidHandler getUpdatedHandler(IoDirection direction) {
        return (IFluidHandler)this.getMultiblockController().flatMap(c -> c.getFluidHandler(direction)).orElse(EmptyFluidHandler.INSTANCE);
    }
}

