/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidizerFluidMixingRecipe
extends AbstractTwoToOneRecipe<FluidStack, FluidStack, FluidStack, FluidStackRecipeIngredient, FluidStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static long s_maxResultAmount = 0L;

    public FluidizerFluidMixingRecipe(FluidStackRecipeIngredient ingredient1, FluidStackRecipeIngredient ingredient2, FluidStackRecipeResult result) {
        super((IRecipeIngredient)ingredient1, (IRecipeIngredient)ingredient2, (IRecipeResult)result);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<FluidStack> source1, IRecipeIngredientSource<FluidStack> source2) {
        return recipe instanceof FluidizerFluidMixingRecipe && ((FluidizerFluidMixingRecipe)recipe).test((FluidStack)source1.getIngredient(), (FluidStack)source2.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.FluidMixing;
    }

    public boolean match(FluidStack stack) {
        return ((FluidStackRecipeIngredient)this.getIngredient1()).test(stack) || ((FluidStackRecipeIngredient)this.getIngredient2()).test(stack);
    }

    public boolean match(FluidStack stack1, FluidStack stack2) {
        FluidStackRecipeIngredient ingredient1 = (FluidStackRecipeIngredient)this.getIngredient1();
        FluidStackRecipeIngredient ingredient2 = (FluidStackRecipeIngredient)this.getIngredient2();
        return ingredient1.test(stack1) && ingredient2.test(stack2);
    }

    public boolean matchIgnoreAmount(FluidStack stack) {
        return ((FluidStackRecipeIngredient)this.getIngredient1()).testIgnoreAmount(stack) || ((FluidStackRecipeIngredient)this.getIngredient2()).testIgnoreAmount(stack);
    }

    public static RecipeSerializer<FluidizerFluidMixingRecipe> createSerializer() {
        return AbstractTwoToOneRecipe.createSerializer((String)"ingredient1", (ModCodecs)FluidStackRecipeIngredient.CODECS, (String)"ingredient2", (ModCodecs)FluidStackRecipeIngredient.CODECS, (String)"result", (ModCodecs)FluidStackRecipeResult.CODECS, FluidizerFluidMixingRecipe::new);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public RecipeSerializer<FluidizerFluidMixingRecipe> getSerializer() {
        return Content.Recipes.FLUIDIZER_FLUIDMIXING_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)Content.Recipes.FLUIDIZER_RECIPE_TYPE.get();
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerFluidMixingRecipe>
    implements IFluidizerRecipe.Held<FluidizerFluidMixingRecipe> {
        private final IRecipeIngredientSource<FluidStack> _fluid1Source;
        private final IRecipeIngredientSource<FluidStack> _fluid2Source;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerFluidMixingRecipe>> HeldRecipe(FluidizerFluidMixingRecipe recipe, Holder holder, IRecipeIngredientSource<FluidStack> fluid1Source, IRecipeIngredientSource<FluidStack> fluid2Source, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._fluid1Source = fluid1Source;
            this._fluid2Source = fluid2Source;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerFluidMixingRecipe recipe = (FluidizerFluidMixingRecipe)this.getRecipe();
            FluidStack fluid1 = (FluidStack)this._fluid1Source.getMatchFrom(recipe.getIngredient1());
            FluidStack fluid2 = (FluidStack)this._fluid2Source.getMatchFrom(recipe.getIngredient2());
            if (!fluid1.isEmpty() && !fluid2.isEmpty()) {
                this._fluid1Source.consumeIngredient((Object)fluid1);
                this._fluid2Source.consumeIngredient((Object)fluid2);
                this._outputTarget.setResult((IRecipeResult)((FluidStackRecipeResult)recipe.getResult()), OperationMode.Execute);
            }
        }
    }
}

