/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.Reaction;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.fluidizer.FluidizerRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantFromSolidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactionsRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.TransitionsRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reprocessor.ReprocessorRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ExtremeReactorsJeiPlugin
implements IModPlugin {
    public static final RecipeType<ReprocessorRecipe> REPROCESSOR_JEI_RECIPE_TYPE = RecipeType.create((String)"bigreactors", (String)"reprocessor", ReprocessorRecipe.class);
    public static final RecipeType<FluidizerSolidRecipe> FLUIDIZER_SOLID_JEI_RECIPE_TYPE = RecipeType.create((String)"bigreactors", (String)"fluidizer_solid", FluidizerSolidRecipe.class);
    public static final RecipeType<FluidizerSolidMixingRecipe> FLUIDIZER_SOLIDMIXING_JEI_RECIPE_TYPE = RecipeType.create((String)"bigreactors", (String)"fluidizer_solidmixing", FluidizerSolidMixingRecipe.class);
    public static final RecipeType<FluidizerFluidMixingRecipe> FLUIDIZER_FLUIDMIXING_JEI_RECIPE_TYPE = RecipeType.create((String)"bigreactors", (String)"fluidizer_fluidmixing", FluidizerFluidMixingRecipe.class);
    public static final RecipeType<Reaction> REACTION_JEI_RECIPE_TYPE = RecipeType.create((String)"bigreactors", (String)"reactantsreactions", Reaction.class);
    public static final IIngredientType<Reactant> REACTANT_INGREDIENT_TYPE = () -> Reactant.class;
    public static final IIngredientType<Coolant> COOLANT_INGREDIENT_TYPE = () -> Coolant.class;
    public static final IIngredientType<Vapor> VAPOR_INGREDIENT_TYPE = () -> Vapor.class;
    private static final ResourceLocation s_id = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("jeiplugin");
    private ReactantFromSolidRecipeCategory _reactantsSolidMappings;
    private ReactantFromFluidRecipeCategory _reactantsFluidMappings;
    private TransitionsRecipeCategory<Coolant, Vapor, TransitionsRecipeCategory.VaporizationTransition> _vaporizations;
    private TransitionsRecipeCategory<Vapor, Coolant, TransitionsRecipeCategory.CondensationTransition> _condensations;
    private CoolantFromFluidRecipeCategory _coolantsMappings;
    private VaporFromFluidRecipeCategory _vaporsMappings;

    public static IDrawableStatic defaultMappingDrawable(IGuiHelper guiHelper) {
        ResourceLocation id = CommonLocations.TEXTURES_GUI_JEI.buildWithSuffix("mapping.png");
        return guiHelper.drawableBuilder(id, 0, 0, 144, 56).setTextureSize(144, 56).build();
    }

    public ResourceLocation getPluginUid() {
        return s_id;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ReprocessorRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.solid(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.solidMixing(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.fluidMixing(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReactionsRecipeCategory(guiHelper)});
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this._reactantsSolidMappings = new ReactantFromSolidRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this._reactantsSolidMappings;
        registration.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this._reactantsFluidMappings = new ReactantFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray2[0] = this._reactantsFluidMappings;
        registration.addRecipeCategories(iRecipeCategoryArray2);
        IRecipeCategory[] iRecipeCategoryArray3 = new IRecipeCategory[1];
        this._vaporizations = TransitionsRecipeCategory.vaporization(guiHelper);
        iRecipeCategoryArray3[0] = this._vaporizations;
        registration.addRecipeCategories(iRecipeCategoryArray3);
        IRecipeCategory[] iRecipeCategoryArray4 = new IRecipeCategory[1];
        this._condensations = TransitionsRecipeCategory.condensation(guiHelper);
        iRecipeCategoryArray4[0] = this._condensations;
        registration.addRecipeCategories(iRecipeCategoryArray4);
        IRecipeCategory[] iRecipeCategoryArray5 = new IRecipeCategory[1];
        this._coolantsMappings = new CoolantFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray5[0] = this._coolantsMappings;
        registration.addRecipeCategories(iRecipeCategoryArray5);
        IRecipeCategory[] iRecipeCategoryArray6 = new IRecipeCategory[1];
        this._vaporsMappings = new VaporFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray6[0] = this._vaporsMappings;
        registration.addRecipeCategories(iRecipeCategoryArray6);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(REPROCESSOR_JEI_RECIPE_TYPE, Content.Recipes.REPROCESSOR_RECIPE_TYPE.get().getRecipes());
        registration.addRecipes(FLUIDIZER_SOLID_JEI_RECIPE_TYPE, Content.Recipes.FLUIDIZER_RECIPE_TYPE.get().getRecipes(r -> r instanceof FluidizerSolidRecipe, r -> (FluidizerSolidRecipe)r));
        registration.addRecipes(FLUIDIZER_SOLIDMIXING_JEI_RECIPE_TYPE, Content.Recipes.FLUIDIZER_RECIPE_TYPE.get().getRecipes(r -> r instanceof FluidizerSolidMixingRecipe, r -> (FluidizerSolidMixingRecipe)r));
        registration.addRecipes(FLUIDIZER_FLUIDMIXING_JEI_RECIPE_TYPE, Content.Recipes.FLUIDIZER_RECIPE_TYPE.get().getRecipes(r -> r instanceof FluidizerFluidMixingRecipe, r -> (FluidizerFluidMixingRecipe)r));
        registration.addRecipes(REACTION_JEI_RECIPE_TYPE, ReactionsRegistry.getReactions());
        registration.addRecipes(this._reactantsSolidMappings.getRecipeType(), this._reactantsSolidMappings.getReactants());
        registration.addRecipes(this._reactantsFluidMappings.getRecipeType(), this._reactantsFluidMappings.getReactants());
        registration.addRecipes(this._vaporizations.getRecipeType(), this._vaporizations.getTransitions());
        registration.addRecipes(this._condensations.getRecipeType(), this._condensations.getTransitions());
        registration.addRecipes(this._coolantsMappings.getRecipeType(), this._coolantsMappings.getCoolants());
        registration.addRecipes(this._vaporsMappings.getRecipeType(), this._vaporsMappings.getVapors());
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(REACTANT_INGREDIENT_TYPE, ReactantsRegistry.getReactants(), (IIngredientHelper)new ReactantIngredientHelper(), (IIngredientRenderer)new ReactantIngredientRenderer(), Reactant.CODECS.codec());
        registration.register(COOLANT_INGREDIENT_TYPE, FluidsRegistry.getCoolants(), (IIngredientHelper)new CoolantIngredientHelper(), (IIngredientRenderer)new CoolantIngredientRenderer(), Coolant.CODECS.codec());
        registration.register(VAPOR_INGREDIENT_TYPE, FluidsRegistry.getVapors(), (IIngredientHelper)new VaporIngredientHelper(), (IIngredientRenderer)new VaporIngredientRenderer(), Vapor.CODECS.codec());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        ItemStack ingredient = new ItemStack((ItemLike)Content.Blocks.REPROCESSOR_CONTROLLER.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{REPROCESSOR_JEI_RECIPE_TYPE});
        ingredient = new ItemStack((ItemLike)Content.Blocks.FLUIDIZER_CONTROLLER.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{FLUIDIZER_SOLID_JEI_RECIPE_TYPE});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{FLUIDIZER_SOLIDMIXING_JEI_RECIPE_TYPE});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{FLUIDIZER_FLUIDMIXING_JEI_RECIPE_TYPE});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_CONTROLLER_BASIC.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{REACTION_JEI_RECIPE_TYPE});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_CONTROLLER_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{REACTION_JEI_RECIPE_TYPE});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporizations.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._condensations.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_SOLID_ACCESSPORT_BASIC.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._reactantsSolidMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_SOLID_ACCESSPORT_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._reactantsSolidMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._reactantsFluidMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
        ingredient = new ItemStack((ItemLike)Content.Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._vaporsMappings.getRecipeType()});
        registration.addRecipeCatalyst(ingredient, new RecipeType[]{this._coolantsMappings.getRecipeType()});
    }
}

