/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipe;

import it.zerono.mods.extremereactors.datagen.recipe.AbstractRecipesDataProvider;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.mekanism.IMekanismService;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class ReactorRecipesDataProvider
extends AbstractRecipesDataProvider {
    public ReactorRecipesDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super("bigreactors", "Reactor recipes", output, registryLookup, modLocationRoot);
    }

    protected void buildRecipes(RecipeOutput output) {
        ReactorVariant variant = ReactorVariant.Basic;
        Supplier<BlockItem> casing = Content.Items.REACTOR_CASING_BASIC;
        TagKey core = Tags.Items.SANDS_COLORLESS;
        TagKey metal = Tags.Items.INGOTS_IRON;
        TagKey fallbackMetal = null;
        this.casing(output, variant, Content.Items.REACTOR_CASING_BASIC, (TagKey<Item>)core, (TagKey<Item>)metal, fallbackMetal);
        this.casingRecycle(output, variant, Content.Items.REACTOR_CASING_BASIC, ContentTags.Items.USING_REACTOR_CASING_BASIC, Content.Items.REACTOR_GLASS_BASIC);
        this.glass(output, variant, Content.Items.REACTOR_GLASS_BASIC, casing, (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
        this.controller(output, variant, Content.Items.REACTOR_CONTROLLER_BASIC, casing, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.fuelRod(output, variant, Content.Items.REACTOR_FUELROD_BASIC, (TagKey<Item>)metal, fallbackMetal, (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
        this.controlRod(output, variant, Content.Items.REACTOR_CONTROLROD_BASIC, casing, (TagKey<Item>)metal, fallbackMetal);
        this.solidAccessPort(output, variant, Content.Items.REACTOR_SOLID_ACCESSPORT_BASIC, casing, (TagKey<Item>)metal, fallbackMetal);
        this.powerTap(output, variant, "fe", Content.Items.REACTOR_POWERTAP_FE_PASSIVE_BASIC, Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, casing, () -> Items.REDSTONE_BLOCK, () -> Items.REDSTONE);
        this.redstonePort(output, variant, Content.Items.REACTOR_REDSTONEPORT_BASIC, casing, (TagKey<Item>)metal, fallbackMetal, (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.chargingPort(output, this.reactorRoot(variant).buildWithSuffix("chargingfe"), Content.Items.REACTOR_CHARGINGPORT_FE_BASIC, Content.Items.REACTOR_POWERTAP_FE_ACTIVE_BASIC, (ItemLike)Items.LAPIS_LAZULI, (ItemLike)Items.REDSTONE);
        variant = ReactorVariant.Reinforced;
        casing = Content.Items.REACTOR_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        fallbackMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.casing(output, variant, Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.casingUpgrade(output, variant, Content.Items.REACTOR_CASING_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.casingRecycle(output, variant, Content.Items.REACTOR_CASING_REINFORCED, ContentTags.Items.USING_REACTOR_CASING_REINFORCED, Content.Items.REACTOR_GLASS_REINFORCED);
        this.glass(output, variant, Content.Items.REACTOR_GLASS_REINFORCED, casing, (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
        this.controller(output, variant, Content.Items.REACTOR_CONTROLLER_REINFORCED, casing, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.fuelRod(output, variant, Content.Items.REACTOR_FUELROD_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.GLASS_BLOCKS);
        this.controlRod(output, variant, Content.Items.REACTOR_CONTROLROD_REINFORCED, casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.solidAccessPort(output, variant, Content.Items.REACTOR_SOLID_ACCESSPORT_REINFORCED, casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.fluidAccessPort(output, variant, Content.Items.REACTOR_FLUID_ACCESSPORT_REINFORCED, casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.powerTap(output, variant, "fe", Content.Items.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, casing, () -> Items.REDSTONE_BLOCK, () -> Items.REDSTONE);
        this.redstonePort(output, variant, Content.Items.REACTOR_REDSTONEPORT_REINFORCED, casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_GOLD);
        this.computerPort(output, variant, Content.Items.REACTOR_COMPUTERPORT_REINFORCED, casing, (TagKey<Item>)metal, (TagKey<Item>)fallbackMetal);
        this.fluidPort(output, variant, "forge", Content.Items.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, Content.Items.REACTOR_FLUIDPORT_FORGE_ACTIVE_REINFORCED, casing, () -> Items.LAVA_BUCKET, () -> Items.WATER_BUCKET);
        this.mekFluidPort(output, variant, Content.Items.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, casing, () -> Items.LAVA_BUCKET, () -> Items.WATER_BUCKET);
        this.chargingPort(output, this.reactorRoot(variant).buildWithSuffix("chargingfe"), Content.Items.REACTOR_CHARGINGPORT_FE_REINFORCED, Content.Items.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, (ItemLike)Items.LAPIS_BLOCK, (ItemLike)Items.REDSTONE_BLOCK);
    }

    private void casing(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> core, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("casing"), metal, idBuilder.buildWithSuffix("casing_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('I'), tag).define(Character.valueOf('C'), core).define(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).pattern("IGI").pattern("GCG").pattern("IGI").unlockedBy("has_item", ReactorRecipesDataProvider.has(ContentTags.Items.INGOTS_GRAPHITE)));
    }

    private void casingUpgrade(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("casing_upgrade"), metal, idBuilder.buildWithSuffix("casing_upgrade_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('I'), tag).define(Character.valueOf('C'), (ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()).define(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).pattern("IGI").pattern("GCG").pattern("IGI").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)Content.Blocks.REACTOR_CASING_BASIC.get()))));
    }

    private void casingRecycle(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> casingResult, TagKey<Item> casingSourceTag, Supplier<? extends ItemLike> glassSourceItem) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, casingResult).requires(glassSourceItem.get()).unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)glassSourceItem.get())).save(output, idBuilder.buildWithSuffix("casing_recycle_glass"));
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, casingResult, 4).requires(casingSourceTag).unlockedBy("has_item", ReactorRecipesDataProvider.has(casingSourceTag)).save(output, idBuilder.buildWithSuffix("casing_recycle"));
    }

    private void glass(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> glass) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('G'), glass).pattern("GCG").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).save(output, this.reactorRoot(variant).buildWithSuffix("glass"));
    }

    private void controller(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> diamond) {
        TAGS_YELLORIUM_INGOTS.forEach(tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('Y'), tag).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('D'), diamond).define(Character.valueOf('X'), (ItemLike)Items.COMPARATOR).pattern("CXC").pattern("YDY").pattern("CRC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))).unlockedBy("has_item2", ReactorRecipesDataProvider.has((TagKey)tag)).save(output, this.nameForTaggedSubtype("controller", variant, (TagKey<Item>)tag)));
    }

    private void fuelRod(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal, TagKey<Item> glass) {
        TAGS_YELLORIUM_INGOTS.forEach(tag -> this.withFallback(output, this.nameForTaggedSubtype("fuelrod", variant, (TagKey<Item>)tag), metal, this.nameForTaggedSubtype("fuelrod_alt", variant, (TagKey<Item>)tag), fallbackMetal, arg_0 -> this.lambda$fuelRod$11((Supplier)result, tag, glass, arg_0)));
    }

    private void controlRod(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("controlrod"), metal, idBuilder.buildWithSuffix("controlrod_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('M'), tag).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).define(Character.valueOf('X'), (ItemLike)Items.PISTON).pattern("CRC").pattern("MXM").pattern("CGC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))));
    }

    private void powerTap(RecipeOutput output, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> energyBig, Supplier<? extends ItemLike> energySmall) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant).append(name);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('B'), energyBig.get()).define(Character.valueOf('S'), energySmall.get()).pattern("CSC").pattern("SBS").pattern("CSC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).unlockedBy("has_item2", ReactorRecipesDataProvider.has((ItemLike)energySmall.get())).save(output, idBuilder.buildWithPrefix("passivetap_"));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, activeResult).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('B'), energyBig.get()).define(Character.valueOf('S'), energySmall.get()).pattern("CBC").pattern("BSB").pattern("CBC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).unlockedBy("has_item2", ReactorRecipesDataProvider.has((ItemLike)energyBig.get())).save(output, idBuilder.buildWithPrefix("activetap_"));
    }

    private void fluidPort(RecipeOutput output, ReactorVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant).append(name);
        this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('B'), lava.get()).define(Character.valueOf('S'), water.get()).pattern("CSC").pattern("SBS").pattern("CSC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).unlockedBy("has_item2", ReactorRecipesDataProvider.has((ItemLike)water.get())).save(output, idBuilder.buildWithPrefix("passivefluidport_"));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, activeResult).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('B'), lava.get()).define(Character.valueOf('S'), water.get()).pattern("CBC").pattern("BSB").pattern("CBC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).unlockedBy("has_item2", ReactorRecipesDataProvider.has((ItemLike)lava.get())).save(output, idBuilder.buildWithPrefix("activefluidport_"));
    }

    private void mekFluidPort(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        output = output.withConditions(new ICondition[]{ReactorRecipesDataProvider.modLoaded((String)IMekanismService.SERVICE.getId())});
        this.shaped(RecipeCategory.BUILDING_BLOCKS, passiveResult).define(Character.valueOf('C'), casing.get()).define(Character.valueOf('B'), lava.get()).define(Character.valueOf('S'), water.get()).define(Character.valueOf('X'), (ItemLike)Items.EMERALD_BLOCK).pattern("CSC").pattern("BXB").pattern("CSC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)casing.get())).unlockedBy("has_item2", ReactorRecipesDataProvider.has((ItemLike)water.get())).save(output, this.reactorRoot(variant).buildWithSuffix("passivefluidport_mekanism"));
    }

    private void solidAccessPort(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("solidaccessport"), metal, idBuilder.buildWithSuffix("solidaccessport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('M'), tag).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('W'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('X'), (ItemLike)Items.PISTON).pattern("CHC").pattern("MWM").pattern("CXC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))));
    }

    private void fluidAccessPort(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("fluidaccessport"), metal, idBuilder.buildWithSuffix("fluidaccessport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('M'), tag).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('W'), (ItemLike)Items.BUCKET).define(Character.valueOf('X'), (ItemLike)Items.PISTON).pattern("CHC").pattern("MWM").pattern("CXC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))));
    }

    private void redstonePort(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal, TagKey<Item> gold) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("redstoneport"), metal, idBuilder.buildWithSuffix("redstoneport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('M'), tag).define(Character.valueOf('G'), gold).define(Character.valueOf('Z'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('X'), (ItemLike)Items.REPEATER).pattern("CZC").pattern("MGM").pattern("CXC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))));
    }

    private void computerPort(RecipeOutput output, ReactorVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> fallbackMetal) {
        ResourceLocationBuilder idBuilder = this.reactorRoot(variant);
        this.withFallback(output, idBuilder.buildWithSuffix("computerport"), metal, idBuilder.buildWithSuffix("computerport_alt"), fallbackMetal, tag -> this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('C'), (ItemLike)casing.get()).define(Character.valueOf('M'), tag).define(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).define(Character.valueOf('Z'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('X'), Tags.Items.DUSTS_GLOWSTONE).pattern("CZC").pattern("MGM").pattern("CXC").unlockedBy("has_item", ReactorRecipesDataProvider.has((ItemLike)((ItemLike)casing.get()))));
    }

    private ResourceLocation nameForTaggedSubtype(String baseName, ReactorVariant variant, TagKey<Item> tag) {
        return this.reactorRoot(variant).buildWithSuffix(baseName + "_" + tag.location().getPath().replace('/', '_'));
    }

    private /* synthetic */ RecipeBuilder lambda$fuelRod$11(Supplier result, TagKey tag, TagKey glass, TagKey metalTag) {
        return this.shaped(RecipeCategory.BUILDING_BLOCKS, result).define(Character.valueOf('M'), metalTag).define(Character.valueOf('Y'), tag).define(Character.valueOf('G'), ContentTags.Items.INGOTS_GRAPHITE).define(Character.valueOf('L'), glass).pattern("MGM").pattern("LYL").pattern("MGM").unlockedBy("has_item", ReactorRecipesDataProvider.has((TagKey)tag));
    }
}

