/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.internal.modpack.wrapper;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.coolant.FluidMappingsRegistry;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.TransitionsRegistry;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.CoilMaterial;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Coolant;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.FuelProperties;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Mapping;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Moderator;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Reactant;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Reaction;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.SourceTag;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Vapor;
import it.zerono.mods.extremereactors.api.reactor.ModeratorsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public final class ApiWrapper {
    public boolean Enabled = false;
    public AddRemoveSection<Coolant> Coolants = new AddRemoveSection(Coolant[]::new);
    public AddRemoveSection<Vapor> Vapors = new AddRemoveSection(Vapor[]::new);
    public AddRemoveSection<SourceTag> CoolantSources = new AddRemoveSection(SourceTag[]::new);
    public AddRemoveSection<SourceTag> VaporSources = new AddRemoveSection(SourceTag[]::new);
    public AddRemoveSection<Mapping> FluidTransitions = new AddRemoveSection(Mapping[]::new);
    public AddRemoveSection<Reactant> ReactorReactants = new AddRemoveSection(Reactant[]::new);
    public AddRemoveSection<SourceTag> ReactorReactantSources = new AddRemoveSection(SourceTag[]::new);
    public AddRemoveSection<Reaction> ReactorReactantReaction = new AddRemoveSection(Reaction[]::new);
    public AddRemoveSection<Moderator> ReactorSolidModerators = new AddRemoveSection(Moderator[]::new);
    public AddRemoveSection<Moderator> ReactorFluidModerators = new AddRemoveSection(Moderator[]::new);
    public AddRemoveSection<CoilMaterial> TurbineCoils = new AddRemoveSection(CoilMaterial[]::new);
    private static final Gson s_gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});

    public static void generateSampleFile() {
        ApiWrapper wrapper = new ApiWrapper();
        wrapper.Coolants.Add = ImmutableList.of((Object)new Coolant("coolantA", "key.for.coolantA.name", 100.0f, 24.3f), (Object)new Coolant("coolantB", "key.for.coolantB.name.translation", 85.34f, 12.0f)).toArray((Object[])new Coolant[0]);
        wrapper.Coolants.Remove = new String[]{"someCoolant", "water", "anotherCoolantName"};
        wrapper.Vapors.Add = ImmutableList.of((Object)new Vapor("vapor1", "vapor1.name.translation.key", 2.0f), (Object)new Vapor("vapor2", "vapor2.the_name.translation.key.for_the_vapor", 1.25f)).toArray((Object[])new Vapor[0]);
        wrapper.Vapors.Remove = new String[]{"vaporA", "theVapor4", "steam"};
        wrapper.CoolantSources.Add = ImmutableList.of((Object)new SourceTag("minecraft:lava", "coolantA", 7), (Object)new SourceTag("modid:fluidid", "coolantB", 1)).toArray((Object[])new SourceTag[0]);
        wrapper.CoolantSources.Remove = new String[]{"minecraft:water", "minecraft:lava", "anothermod:fluid"};
        wrapper.VaporSources.Add = ImmutableList.of((Object)new SourceTag("forge:steam", "vapor2", 1), (Object)new SourceTag("modid:fluidid2", "vapor1", 2)).toArray((Object[])new SourceTag[0]);
        wrapper.VaporSources.Remove = new String[]{"minecraft:water", "minecraft:lava", "anothermod:fluid"};
        wrapper.FluidTransitions.WipeExistingValuesBeforeAdding = true;
        wrapper.FluidTransitions.Add = ImmutableList.of((Object)new Mapping("coolantA", 1, "vapor2", 1), (Object)new Mapping("coolantB", 1, "vapor1", 2)).toArray((Object[])new Mapping[0]);
        wrapper.ReactorReactants.Add = ImmutableList.of((Object)new Reactant("newReactant2", "mod.reactant2.name.key", true, 13023828), (Object)new Reactant("newReactant3", "mod.reactant3.name.key", true, 13023828, new FuelProperties(2.5f, 0.9f, 1.3f)), (Object)new Reactant("mywaste", "mywaste.name.key", false, 52533)).toArray((Object[])new Reactant[0]);
        wrapper.ReactorReactants.Remove = new String[]{"cyanite"};
        wrapper.ReactorReactantSources.Add = ImmutableList.of((Object)new SourceTag("forge:ingots/yellorium", "yellorium", 1), (Object)new SourceTag("forge:ingots/iron", "yellorium", 2)).toArray((Object[])new SourceTag[0]);
        wrapper.ReactorReactantSources.Remove = new String[]{"forge:ingots/cyanite"};
        wrapper.ReactorReactantReaction.Add = ImmutableList.of((Object)new Reaction("yellorium", "cyanite", 1.05f, 0.01f), (Object)new Reaction("newReactant2", "mywaste", 1.5f, 0.03f)).toArray((Object[])new Reaction[0]);
        wrapper.ReactorReactantReaction.Remove = new String[]{"yellorium", "newReactant2"};
        wrapper.ReactorSolidModerators.Add = ImmutableList.of((Object)new Moderator("forge:storage_blocks/iron", 0.5f, 0.75f, 1.4f, 0.6f)).toArray((Object[])new Moderator[0]);
        wrapper.ReactorSolidModerators.Remove = new String[]{"forge:storage_blocks/diamond", "forge:storage_blocks/copper"};
        wrapper.ReactorFluidModerators.Add = ImmutableList.of((Object)new Moderator("minecraft:water", 0.5f, 0.75f, 1.4f, 0.6f)).toArray((Object[])new Moderator[0]);
        wrapper.ReactorFluidModerators.Remove = new String[]{"minecraft:flowing_water"};
        wrapper.TurbineCoils.Add = ImmutableList.of((Object)new CoilMaterial("forge:storage_blocks/iron", 1.0f, 1.0f, 1.0f)).toArray((Object[])new CoilMaterial[0]);
        wrapper.TurbineCoils.Remove = new String[]{"forge:storage_blocks/gold", "forge:storage_blocks/copper"};
        ApiWrapper.saveToJSON(wrapper);
    }

    public static void processFile() {
        ApiWrapper wrapper = ApiWrapper.createFromJSON();
        if (null == wrapper || !wrapper.Enabled) {
            return;
        }
        ExtremeReactorsAPI.LOGGER.info(WRAPPER, "Processing ModPack API Wrapper config");
        ReactantsRegistry.processWrapper(wrapper);
        ReactantMappingsRegistry.processWrapper(wrapper);
        ReactionsRegistry.processWrapper(wrapper);
        ModeratorsRegistry.processWrapper(wrapper);
        FluidsRegistry.processWrapper(wrapper);
        FluidMappingsRegistry.processWrapper(wrapper);
        TransitionsRegistry.processWrapper(wrapper);
        CoilMaterialRegistry.processWrapper(wrapper);
    }

    @Nullable
    private static ApiWrapper createFromJSON() {
        Path filePath = ApiWrapper.getPath();
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                return (ApiWrapper)s_gson.fromJson(new JsonReader((Reader)new FileReader(filePath.toFile())), ApiWrapper.class);
            }
            catch (FileNotFoundException e) {
                Log.LOGGER.error((Object)e);
            }
        }
        return null;
    }

    private static void saveToJSON(ApiWrapper wrapper) {
        FileWriter file = null;
        try {
            file = new FileWriter(ApiWrapper.getPath().toFile());
            s_gson.toJson((Object)wrapper, (Appendable)file);
        }
        catch (IOException e) {
            Log.LOGGER.error((Object)e);
        }
        finally {
            if (null != file) {
                try {
                    file.flush();
                    file.close();
                }
                catch (IOException e) {
                    Log.LOGGER.error((Object)e);
                }
            }
        }
    }

    private static Path getPath() {
        return FMLPaths.CONFIGDIR.get().resolve("extremereactors/modpack_api.json");
    }
}

