/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.recipe.imbuement;

import com.github.jarva.arsadditions.setup.registry.AddonRecipeRegistry;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.ItemCasterProvider;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.hollingsworth.arsnouveau.common.items.ManipulationEssence;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record BulkScribingRecipe(ResourceLocation id) implements IImbuementRecipe
{
    public boolean matches(ImbuementTile imbuementTile, Level pLevel) {
        ItemStack reagent = imbuementTile.stack;
        List pedestalItems = imbuementTile.getPedestalItems();
        if (pedestalItems.size() != 1) {
            return false;
        }
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isEmpty()) {
            return false;
        }
        ItemStack scriberStack = scriber.get();
        Item item = scriberStack.getItem();
        if (!(item instanceof ItemCasterProvider)) {
            return false;
        }
        ItemCasterProvider itemCaster = (ItemCasterProvider)item;
        AbstractCaster caster = itemCaster.getSpellCaster(scriberStack);
        if (caster == null || caster.getSpell().isEmpty()) {
            return false;
        }
        Item item2 = reagent.getItem();
        if (item2 instanceof ItemCasterProvider) {
            ItemCasterProvider reagentItemCaster = (ItemCasterProvider)item2;
            AbstractCaster reagentCaster = reagentItemCaster.getSpellCaster(reagent);
            if (reagentCaster == null) {
                return false;
            }
            return !reagentCaster.getSpell().equals((Object)caster.getSpell());
        }
        return reagent.getItem() instanceof IScribeable;
    }

    public Optional<ItemStack> findScriber(ImbuementTile imbuementTile) {
        return imbuementTile.getPedestalItems().stream().filter(this::isScriber).findFirst();
    }

    public boolean isScriber(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof SpellBook || item instanceof SpellParchment || item instanceof ManipulationEssence;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        Item item;
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isPresent() && (item = scriber.get().getItem()) instanceof ItemCasterProvider) {
            ItemCasterProvider provider = (ItemCasterProvider)item;
            return provider.getSpellCaster(scriber.get()).getSpell().getCost();
        }
        return 1000;
    }

    public ItemStack assemble(ImbuementTile imbuementTile, HolderLookup.Provider provider) {
        Item item;
        ItemStack result = imbuementTile.stack.copy();
        if (result.is((Item)ItemsRegistry.BLANK_PARCHMENT.get())) {
            result = new ItemStack((ItemLike)ItemsRegistry.SPELL_PARCHMENT.get());
        }
        if ((item = result.getItem()) instanceof IScribeable) {
            IScribeable scribeable = (IScribeable)item;
            item = imbuementTile.getLevel();
            if (item instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)item;
                Optional<ItemStack> scriber = this.findScriber(imbuementTile);
                if (scriber.isPresent()) {
                    ItemStack is = scriber.get();
                    ANFakePlayer player = ANFakePlayer.getPlayer((ServerLevel)serverLevel);
                    player.setItemInHand(InteractionHand.MAIN_HAND, is);
                    scribeable.onScribe(imbuementTile.getLevel(), imbuementTile.getBlockPos(), (Player)player, InteractionHand.MAIN_HAND, result);
                }
            }
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AddonRecipeRegistry.BULK_SCRIBING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AddonRecipeRegistry.BULK_SCRIBING_TYPE.get();
    }

    public Component getCraftingStartedText(ImbuementTile imbuementTile) {
        return Component.translatable((String)"chat.ars_additions.imbued_spell_parchment.scribing_started", (Object[])new Object[]{this.assemble(imbuementTile, (HolderLookup.Provider)imbuementTile.getLevel().registryAccess()).getHoverName()});
    }

    public Component getCraftingText(ImbuementTile imbuementTile) {
        Item item;
        Optional<ItemStack> scriber = this.findScriber(imbuementTile);
        if (scriber.isPresent() && (item = scriber.get().getItem()) instanceof ItemCasterProvider) {
            ItemCasterProvider provider = (ItemCasterProvider)item;
            return Component.translatable((String)"tooltip.ars_additions.imbued_spell_parchment.scribing", (Object[])new Object[]{provider.getSpellCaster(scriber.get()).getSpell().getDisplayString()});
        }
        return Component.translatable((String)"tooltip.ars_additions.imbued_spell_parchment.scribing", (Object[])new Object[]{this.assemble(imbuementTile, (HolderLookup.Provider)imbuementTile.getLevel().registryAccess()).getHoverName()});
    }

    public Component getCraftingProgressText(ImbuementTile imbuementTile, int progress) {
        return Component.translatable((String)"tooltip.ars_additions.imbued_spell_parchment.scribing_progress", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GOLD);
    }

    public static class Serializer
    implements RecipeSerializer<BulkScribingRecipe> {
        public static final MapCodec<BulkScribingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(BulkScribingRecipe::id)).apply((Applicative)instance, BulkScribingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BulkScribingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BulkScribingRecipe::id, BulkScribingRecipe::new);

        public MapCodec<BulkScribingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BulkScribingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

