/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.mana.ActiveCircleConfig;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.AboveChecker;
import stepsword.mahoutsukai.tile.MahoujinTickingTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class ContractMahoujinTileEntity
extends MahoujinTickingTileEntity
implements AboveChecker {
    public ContractMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.contract.get(), p, bs);
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
    }

    @Override
    public Class<? extends Entity> checkForEntity() {
        return Player.class;
    }

    @Override
    public int checkTicks() {
        return MTConfig.CONTRACT_BLOCK_CYCLE;
    }

    @Override
    public boolean firstEntityOnly() {
        return true;
    }

    @Override
    public boolean preConditions() {
        return !this.level.isClientSide && ActiveCircleConfig.tryToOperate(this, this.getCasterUUID());
    }

    @Override
    public boolean ifEntityFoundAbove(Entity e) {
        Player caster;
        MahouSavedData save = Utils.getWorldMahou(this.level);
        ArrayList<Player> targets = this.getTargets();
        if (targets != null && !targets.isEmpty() && e instanceof Player && (caster = (Player)e) != null) {
            for (Player entityIn : targets) {
                if (save.doesContractExist(caster.getUUID(), entityIn.getUUID()) || PlayerManaManager.drainMana(caster, MTConfig.CONTRACT_MANA_COST, false, false) != MTConfig.CONTRACT_MANA_COST || !save.addContractIfNotExists(caster.getUUID(), entityIn.getUUID())) continue;
                entityIn.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "A contract has been formed with " + caster.getDisplayName().getString())), true);
                caster.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "A contract has been formed with " + entityIn.getDisplayName().getString())), true);
            }
        }
        return false;
    }

    public ArrayList<Player> getTargets() {
        int radius = MTConfig.CONTRACT_RADIUS;
        Stream blocks = BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-radius, -radius, -radius), (BlockPos)this.worldPosition.offset(radius, radius, radius));
        ArrayList<Player> ret = new ArrayList<Player>();
        blocks.forEach(tmp -> {
            BlockEntity te = this.level.getBlockEntity(tmp);
            if (te instanceof ContractMahoujinTileEntity) {
                Player p;
                Object patt0$temp;
                List es;
                ContractMahoujinTileEntity mte = (ContractMahoujinTileEntity)te;
                if (!this.worldPosition.equals(tmp) && !(es = mte.checkAbove(te, true)).isEmpty() && (patt0$temp = es.getFirst()) instanceof Player && (p = (Player)patt0$temp).isAlive()) {
                    ret.add(p);
                }
            }
        });
        return ret;
    }

    public static boolean isImmuneToSpell(Level world, UUID caster, Entity e) {
        ServerPlayer player;
        MinecraftServer server;
        UUID ownerId;
        MahouSavedData save = Utils.getWorldMahou(world);
        if (e instanceof ArmorStand) {
            return true;
        }
        if (e instanceof TamableAnimal && caster != null && (ownerId = ((TamableAnimal)e).getOwnerUUID()) != null && (ownerId.equals(caster) || save != null && save.doesContractExist(caster, ownerId))) {
            return true;
        }
        if (e instanceof MentalDisplacementEntity && caster != null && (ownerId = ((MentalDisplacementEntity)e).getOwnerId()) != null && (ownerId.equals(caster) || save != null && save.doesContractExist(caster, ownerId))) {
            return true;
        }
        if (e instanceof Player && caster != null) {
            if (e.getUUID().equals(caster)) {
                return true;
            }
            if (save != null && save.doesContractExist(caster, e.getUUID())) {
                return true;
            }
            if (((Player)e).isCreative() || e.isSpectator()) {
                return true;
            }
        }
        return caster != null && e instanceof LivingEntity && (server = world.getServer()) != null && (player = server.getPlayerList().getPlayer(caster)) != null && GeasEffect.hasGeas((Player)player, (LivingEntity)e);
    }

    public static boolean isImmuneToSpellClient(Player caster, Entity e) {
        UUID ownerId;
        if (e instanceof ArmorStand) {
            return true;
        }
        if (e instanceof TamableAnimal && caster != null && (ownerId = ((TamableAnimal)e).getOwnerUUID()) != null && ownerId.equals(caster.getUUID())) {
            return true;
        }
        if (e instanceof MentalDisplacementEntity && caster != null && (ownerId = ((MentalDisplacementEntity)e).getOwnerId()) != null && ownerId.equals(caster.getUUID())) {
            return true;
        }
        if (e instanceof Player && caster != null) {
            if (e.getUUID().equals(caster.getUUID())) {
                return true;
            }
            if (((Player)e).isCreative() || e.isSpectator()) {
                return true;
            }
        }
        return caster != null && e instanceof LivingEntity && GeasEffect.hasGeas(caster, (LivingEntity)e);
    }

    public static void breakContract(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                MahouSavedData save = Utils.getWorldMahou(player.level());
                event.getSource();
                if (event.getSource().getEntity() != null && save.doesContractExist(player.getUUID(), event.getSource().getEntity().getUUID())) {
                    player.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "A contract has broken.")), true);
                    if (event.getSource().getEntity() instanceof Player) {
                        ((Player)event.getSource().getEntity()).displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "A contract has broken.")), true);
                        save.removeContract(player.getUUID(), event.getSource().getEntity().getUUID());
                    }
                }
            }
        }
    }
}

