/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.TickingTileEntity;

public class MahoujinProjectorTileEntity
extends TickingTileEntity {
    public ProjectorValues pv = new ProjectorValues();

    public MahoujinProjectorTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.projector.get(), p, bs);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.pv.read(compound);
        super.loadAdditional(compound, pRegistries);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        this.writeToNBT(compound);
        super.saveAdditional(compound, pRegistries);
    }

    public CompoundTag writeToNBT(CompoundTag compound) {
        compound = this.pv.write(compound);
        return compound;
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.pv = (ProjectorValues)input.getOrDefault(DataComponents.PROJECTOR_VALUES_COMPONENT, (Object)new ProjectorValues());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(DataComponents.PROJECTOR_VALUES_COMPONENT, (Object)(this.pv == null ? new ProjectorValues() : this.pv));
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, TickingTileEntity blockEntity) {
        if (this.pv.cspeed == 0.0f) {
            this.pv.crotation = 0.0f;
        }
        if (this.pv.corbitspeed == 0.0f) {
            this.pv.corbit = 0.0f;
        }
        if (MTConfig.PROJECTOR_CONTINUES_ROTATE_WHEN_OFF || level != null && !level.hasNeighborSignal(this.worldPosition)) {
            this.pv.crotation += this.pv.cspeed;
            this.pv.crotation %= 360.0f;
            this.pv.cpitch += this.pv.cpitspeed;
            this.pv.cpitch %= 360.0f;
            this.pv.cyaw += this.pv.cyawspeed;
            this.pv.cyaw %= 360.0f;
            this.pv.corbit += this.pv.corbitspeed;
            this.pv.corbit %= 360.0f;
            this.pv.gif_frame += this.pv.gif_speed;
            this.pv.gif_frame %= 100000.0f;
        }
    }
}

