/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui.guide;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.DoubleInfoPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.item.guide.InfoPage;
import stepsword.mahoutsukai.item.guide.SpellPage;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.SavePagePacket;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.gui.MahouImageButton;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.render.gui.guide.DoubleInfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.InfoPageGui;
import stepsword.mahoutsukai.render.gui.guide.SpellPageGui;

public class PageGui
extends Screen {
    ResourceLocation guidebookTex = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/gui/guidebook.png");
    public int xSize;
    public int ySize;
    public int tx = 0;
    public int ty = 10;
    public int tx2 = 256;
    public int ty2 = 191;
    public int tleftButtonTx = 72;
    public int tleftButtonTy = 211;
    public int tleftButtonTx2 = 18;
    public int tleftButtonTy2 = 10;
    public int trightButtonTx = 91;
    public int trightButtonTy = 211;
    public int trightButtonTx2 = 18;
    public int trightButtonTy2 = 10;
    public int thomeButtonTx = 115;
    public int thomeButtonTy = 211;
    public int thomeButtonTx2 = 10;
    public int thomeButtonTy2 = 10;
    ArrayList<Button> buttonList = new ArrayList();
    MahouImageButton leftArrow;
    MahouImageButton rightArrow;
    MahouImageButton home;
    int id = 0;
    public float scaleFactor;
    GuidebookInstance guidebook;

    public PageGui(GuidebookInstance guidebook) {
        super((Component)Component.translatable((String)""));
        this.guidebook = guidebook;
        this.scaleFactor = 1.2328767f;
        this.xSize = (int)(this.scaleFactor * (float)this.tx2);
        this.ySize = (int)(this.scaleFactor * (float)this.ty2);
        this.width = this.xSize;
        this.height = this.ySize;
        this.leftArrow = new MahouImageButton(0, 0, this.tleftButtonTx2, this.tleftButtonTy2, this.tleftButtonTx, this.tleftButtonTy, 13, this.guidebookTex, this::actionPerformed);
        this.rightArrow = new MahouImageButton(0, 0, this.trightButtonTx2, this.trightButtonTy2, this.trightButtonTx, this.trightButtonTy, 13, this.guidebookTex, this::actionPerformed);
        this.home = new MahouImageButton(0, 0, this.thomeButtonTx2, this.thomeButtonTy2, this.thomeButtonTx, this.thomeButtonTy, 13, this.guidebookTex, this::actionPerformed);
        this.addExtraButton(this.leftArrow);
        this.addExtraButton(this.rightArrow);
        this.addExtraButton(this.home);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderUtils.bindTexture(this.guidebookTex);
        RenderSystem.enableDepthTest();
        int i = (this.width - this.xSize) / 2;
        int j = (this.height - this.ySize) / 2;
        this.leftArrow.setPosition(i + 20, j + this.ySize - 20);
        this.rightArrow.setPosition(i + this.xSize - 38, j + this.ySize - 20);
        this.home.setPosition(i + 20, j + 15);
        this.drawTexturedModalRect(graphics.pose(), i, j, this.tx, this.ty, this.tx2, this.ty2, this.xSize, this.ySize);
        for (int r = 0; r < this.buttonList.size(); ++r) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            this.buttonList.get(r).render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void drawTexturedModalRect(PoseStack matrix, int x, int y, int textureX, int textureY, int tx2, int ty2, int width, int height) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f m = matrix.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(m, (float)(x + 0), (float)(y + height), 0.0f).setUv((float)(textureX + 0) * 0.00390625f, (float)(textureY + ty2) * 0.00390625f);
        bufferbuilder.addVertex(m, (float)(x + width), (float)(y + height), 0.0f).setUv((float)(textureX + tx2) * 0.00390625f, (float)(textureY + ty2) * 0.00390625f);
        bufferbuilder.addVertex(m, (float)(x + width), (float)(y + 0), 0.0f).setUv((float)(textureX + tx2) * 0.00390625f, (float)(textureY + 0) * 0.00390625f);
        bufferbuilder.addVertex(m, (float)(x + 0), (float)(y + 0), 0.0f).setUv((float)(textureX + 0) * 0.00390625f, (float)(textureY + 0) * 0.00390625f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public void addExtraButton(Button button) {
        this.buttonList.add(button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        for (Button b : this.buttonList) {
            if (!b.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            this.setFocused((GuiEventListener)b);
            b.playDownSound(this.getMinecraft().getSoundManager());
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double side, double up) {
        if (up < 0.0) {
            this.actionPerformed((AbstractWidget)this.rightArrow);
        } else if (up > 0.0) {
            this.actionPerformed((AbstractWidget)this.leftArrow);
        }
        return true;
    }

    public void onClose() {
        PacketHandler.sendToServer(new SavePagePacket(this.guidebook.getCurrentPage()));
        super.onClose();
    }

    protected void actionPerformed(AbstractWidget button) {
        if (button == this.leftArrow) {
            if (this.guidebook.getCurrentPage() > 0) {
                this.navigateToPage(this.guidebook.getCurrentPage() - 1);
            }
        } else if (button == this.rightArrow) {
            if (this.guidebook.getPages().size() > this.guidebook.getCurrentPage() + 1) {
                this.navigateToPage(this.guidebook.getCurrentPage() + 1);
            }
        } else if (button == this.home && this.guidebook.getCurrentPage() > 0) {
            this.navigateToPage(0);
        }
    }

    public void navigateToPage(int page) {
        if (this.guidebook.getCurrentPage() != page) {
            this.guidebook.setCurrentPage(page);
            if (this.guidebook.getPage() instanceof SpellPage) {
                Minecraft.getInstance().setScreen((Screen)new SpellPageGui(this.guidebook, (SpellPage)this.guidebook.getPage()));
            } else if (this.guidebook.getPage() instanceof ContentsPage) {
                Minecraft.getInstance().setScreen((Screen)new ContentsPageGui(this.guidebook, (ContentsPage)this.guidebook.getPage()));
            } else if (this.guidebook.getPage() instanceof InfoPage) {
                Minecraft.getInstance().setScreen((Screen)new InfoPageGui(this.guidebook, (InfoPage)this.guidebook.getPage()));
            } else if (this.guidebook.getPage() instanceof DoubleInfoPage) {
                Minecraft.getInstance().setScreen((Screen)new DoubleInfoPageGui(this.guidebook, (DoubleInfoPage)this.guidebook.getPage()));
            }
        }
    }

    public GuidebookInstance getGuidebook() {
        return this.guidebook;
    }
}

