/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui.guide;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import stepsword.mahoutsukai.item.guide.SpellPage;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;

public class LinkGuiButton
extends Button {
    public String localized;
    public int pageLink;
    ContentsPageGui gui;
    boolean hovered;
    int wrap;

    public LinkGuiButton(int x, int y, int w, int h, String localized, int link, ContentsPageGui gui, int wrap) {
        super(x, y, w, h, (Component)Component.literal((String)""), btn -> gui.navigateToPage(link), DEFAULT_NARRATION);
        this.pageLink = link;
        this.gui = gui;
        this.localized = gui.guidebook.getPages().get(this.pageLink) instanceof SpellPage ? String.valueOf(ChatFormatting.ITALIC) + localized : String.valueOf(ChatFormatting.BOLD) + localized;
        this.wrap = wrap;
    }

    public void renderWidget(GuiGraphics graphics, int mx, int my, float partialTicks) {
        PoseStack stack = graphics.pose();
        stack.pushPose();
        Font font = Minecraft.getInstance().font;
        int wr = this.localized.length() - this.sizeStringToWidth(this.localized, this.wrap, font);
        if (wr > 3) {
            this.localized = this.localized.substring(0, this.localized.length() - wr) + "...";
        } else if (wr > 0 && wr < 3) {
            this.localized = this.localized.substring(0, this.localized.length() - 3) + "...";
        }
        this.hovered = mx >= this.getX() && my >= this.getY() && mx < this.getX() + font.width(this.localized) && my < this.getY() + this.getHeight();
        int color = 0x444444;
        if (this.hovered) {
            color = 0;
        }
        font.drawInBatch(this.localized, (float)this.getX(), (float)this.getY(), color, false, stack.last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.enableBlend();
        stack.popPose();
    }

    public int sizeStringToWidth(String str, int wrapWidth, Font font) {
        int k;
        int i = Math.max(1, wrapWidth);
        int j = str.length();
        float f = 0.0f;
        int l = -1;
        boolean flag = false;
        boolean flag1 = true;
        for (k = 0; k < j; ++k) {
            char c0 = str.charAt(k);
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                }
                default: {
                    if (f != 0.0f) {
                        flag1 = false;
                    }
                    f += this.getCharWidth(c0, font);
                    if (!flag) break;
                    f += 1.0f;
                    break;
                }
                case '\u00a7': {
                    ChatFormatting cf;
                    if (k >= j - 1) break;
                    if ((cf = ChatFormatting.getByCode((char)str.charAt(++k))) == ChatFormatting.BOLD) {
                        flag = true;
                        break;
                    }
                    if (cf == null || cf.isFormat()) break;
                    flag = false;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                break;
            }
            if (!(f > (float)i)) continue;
            if (!flag1) break;
            ++k;
            break;
        }
        return k != j && l != -1 && l < k ? l : k;
    }

    public float getCharWidth(char character, Font fontr) {
        return fontr.width("" + character);
    }
}

