/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.Keybinds;
import stepsword.mahoutsukai.item.replica.Replica;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.ReplicaSwitchPacket;

public class ReplicaGui
extends Screen {
    private int NUM_SECTORS = 7;
    int slotSelected = -1;
    ItemStack stack;
    Level world;

    public ReplicaGui(Level w, ItemStack i) {
        super((Component)Component.literal((String)""));
        this.world = w;
        this.stack = i;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 80;
        double angle = ReplicaGui.mouseAngle(x, y, mouseX, mouseY);
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)this.NUM_SECTORS;
        this.slotSelected = -1;
        GlStateManager._disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i < this.NUM_SECTORS; ++i) {
            boolean mouseInSector = (double)(degPer * (float)i) < angle && angle < (double)(degPer * (float)(i + 1));
            float radius = maxRadius;
            if (mouseInSector) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (i % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (i == 0) {
                buf.addVertex((float)x, (float)y, 0.0f).setColor(r, g, b, a);
            }
            if (mouseInSector) {
                this.slotSelected = i;
                b = 255;
                g = 255;
                r = 255;
            }
            for (float j = 0.0f; j < degPer + step / 2.0f; j += step) {
                float rad = j + (float)i * degPer;
                float xp = (float)x + Mth.cos((float)rad) * radius;
                float yp = (float)y + Mth.sin((float)rad) * radius;
                if (j == 0.0f) {
                    buf.addVertex(xp, yp, 0.0f).setColor(r, g, b, a);
                }
                buf.addVertex(xp, yp, 0.0f).setColor(r, g, b, a);
            }
        }
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        GlStateManager._enableCull();
        if (this.stack != null) {
            for (int j = 0; j < this.NUM_SECTORS; ++j) {
                boolean mouseInSector = (double)(degPer * (float)j) < angle && angle < (double)(degPer * (float)(j + 1));
                float radius = maxRadius;
                if (mouseInSector) {
                    radius *= 1.025f;
                }
                float rad = (float)j * degPer;
                float xp = (float)x + Mth.cos((float)rad) * radius;
                float yp = (float)y + Mth.sin((float)rad) * radius;
                float xsp = xp - 4.0f;
                float ysp = yp;
                String name = j < this.NUM_SECTORS - 1 ? (this.stack.getItem() instanceof Replica ? Replica.getDamageTypeForSlot(this.stack, j) : "EMPTY") : "CLEAR ALL";
                int width = this.font.width(name);
                double mod = 0.6;
                float nextRad = (float)(j + 1) * degPer;
                float x3 = (float)x + Mth.cos((float)nextRad) * radius;
                float y3 = (float)y + Mth.sin((float)nextRad) * radius;
                xsp = xp + (float)x + x3 - 33.0f;
                ysp = yp + (float)y + y3;
                this.font.drawInBatch(name, xsp /= 3.0f, ysp /= 3.0f, 0xFFFFFF, false, graphics.pose().last().pose(), (MultiBufferSource)graphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                mod = 0.8;
            }
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.atan2((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    public void tick() {
        super.tick();
        if (!InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Keybinds.changeMysticCode.getKey().getValue())) {
            this.minecraft.setScreen(null);
            if (this.slotSelected != -1) {
                int slot = this.slotSelected;
                ReplicaSwitchPacket message = new ReplicaSwitchPacket(slot);
                PacketHandler.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.minecraft.options.keyUp, (Object)this.minecraft.options.keyLeft, (Object)this.minecraft.options.keyDown, (Object)this.minecraft.options.keyRight, (Object)this.minecraft.options.keyShift, (Object)this.minecraft.options.keySprint, (Object[])new KeyMapping[]{this.minecraft.options.keyJump});
        for (KeyMapping k : set) {
            KeyMapping.set((InputConstants.Key)k.getKey(), (boolean)k.isDown());
        }
    }
}

