/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.GifInfo;
import stepsword.mahoutsukai.render.GifLoader;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.render.overlay.RenderInterestingBlock;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.ClientImageDownloadUtil;
import stepsword.mahoutsukai.util.EffectUtil;

public class ProjectorRenderer {
    public static int rindex = 0;
    private static final ResourceLocation mahoujin = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/mahoujin_casting.png");
    private static final ResourceLocation runes = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/block/runes.png");

    public static void render(MahoujinProjectorTileEntity te, float partialTicks, PoseStack matrix, MultiBufferSource buffer) {
        if (te.getLevel() != null && te.getLevel().hasNeighborSignal(te.getBlockPos())) {
            return;
        }
        ItemStack stack = Minecraft.getInstance().player.getMainHandItem();
        if (stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof MahoujinProjector) {
            RenderInterestingBlock.renderBox(matrix, buffer, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 220, 220, 10, 255);
        }
        ProjectorRenderer.doProjectorRender(false, te.pv, matrix, buffer, partialTicks, 0.0f, 0.0f, 0.0f);
    }

    public static void doProjectorRender(boolean armor, ProjectorValues te, PoseStack matrix, MultiBufferSource buffer, float partialTicks, float addpitch, float addyaw, float headpitch) {
        if (rindex == 0x7FFFFFFD) {
            rindex = 0;
        }
        float time = ClientHandler.clientTickCounter;
        float offsetx = te.getCx();
        float offsety = te.getCy();
        float offsetz = te.getCz();
        float r = (float)te.getCr() / 255.0f;
        float g = (float)te.getCg() / 255.0f;
        float b = (float)te.getCb() / 255.0f;
        float a = (float)te.getCa() / 255.0f;
        float rotation = te.getRotation();
        float yaw = te.getCyaw();
        float pitch = te.getCpitch();
        float speed = te.getCspeed();
        float ring = te.getCringangle();
        float size = te.getCsize();
        float orbit = te.getCorbitspeed() * time;
        float gif_speed = te.getGifSpeed();
        float gif_frame = gif_speed * time;
        boolean gif_layer = te.getGifLayer();
        boolean showCircle = te.getShowCircle();
        float ringAngle = te.getCringangle();
        float height = te.getHeight();
        int rune = te.getRunes();
        boolean showRing = te.getShowRing();
        float preyaw = te.getCpreyaw();
        float prepitch = te.getCprepitch();
        int loadImage = te.getImage();
        if (!armor) {
            yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks;
            pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks;
            rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
            orbit = te.corbit - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
            gif_frame = te.gif_frame;
        } else {
            rotation = te.getRotation() + te.getCspeed() * time;
            yaw = te.getCyaw() + te.getCyspeed() * time;
            pitch = te.getCpitch() + te.getCpspeed() * time;
            yaw = yaw - te.getCyspeed() + te.getCyspeed() * partialTicks + addyaw;
            pitch = pitch - te.getCpspeed() + te.getCpspeed() * partialTicks + addpitch;
            rotation = te.getRotationOffset() + (rotation - speed) + speed * partialTicks;
            orbit = orbit - te.getCorbitspeed() + te.getCorbitspeed() * partialTicks;
        }
        if (buffer == null) {
            buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        }
        ProjectorRenderer.renderProjector(armor, matrix, buffer, loadImage, showCircle, gif_layer, gif_frame, size, r, g, b, a, ringAngle, height, rune, showRing, ring, prepitch, preyaw, orbit, pitch, yaw, rotation, offsetx, offsety, offsetz, headpitch);
    }

    public static void renderProjector(boolean enchant, PoseStack matrix, MultiBufferSource buffer, int loadImage, boolean showCircle, boolean gif_layer, float gif_frame, float size, float r, float g, float b, float a, float ringangle, float height, int rune, boolean showRing, float ring, float prepitch, float preyaw, float orbit, float pitch, float yaw, float rotation, float offsetx, float offsety, float offsetz, float headpitch) {
        RenderType type;
        float[] uvs = new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        GifInfo gif_first = null;
        boolean is_gif = false;
        float headsize = -0.9f;
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        if (enchant) {
            matrix.translate(-0.5, 0.0, -0.5);
            matrix.translate(0.0f, -headsize, 0.0f);
            RenderUtils.rotateQ(headpitch, 1.0f, 0.0f, 0.0f, matrix);
            matrix.translate(0.0f, headsize, 0.0f);
        }
        matrix.mulPose(Axis.XP.rotationDegrees(prepitch));
        matrix.mulPose(Axis.YP.rotationDegrees(preyaw));
        matrix.mulPose(Axis.XP.rotationDegrees(orbit));
        matrix.translate(offsetx, offsety, offsetz);
        matrix.mulPose(Axis.YP.rotationDegrees(yaw));
        matrix.mulPose(Axis.XP.rotationDegrees(pitch));
        matrix.mulPose(Axis.YP.rotationDegrees(rotation));
        Matrix4f positionMatrix = matrix.last().pose();
        if (loadImage >= 0) {
            for (int j = 0; j < MTConfig.MAGIC_CIRCLES.size(); ++j) {
                ClientImageDownloadUtil.download("circle" + j, MTConfig.MAGIC_CIRCLES.get(j), false);
            }
            if (loadImage < ClientImageDownloadUtil.lst.size()) {
                try {
                    ResourceLocation loc = ClientImageDownloadUtil.lst.get(loadImage);
                    if (ClientImageDownloadUtil.gifmap.containsKey(loc)) {
                        gif_first = ClientImageDownloadUtil.gifmap.get(loc);
                        is_gif = true;
                    }
                    type = MahoujinRenderType.createMahoujinRenderType(loc, 0, false);
                }
                catch (Exception e) {
                    type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
                }
            } else {
                type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
            }
        } else {
            type = MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false);
        }
        int lightmapX = 240;
        int lightmapY = 240;
        if (showCircle) {
            VertexConsumer builder = buffer.getBuffer(type);
            if (is_gif && gif_first != null) {
                if (gif_layer) {
                    int gf = 0;
                    while ((float)gf < gif_frame) {
                        uvs = GifLoader.getUVFromGIF(gf, gif_first);
                        builder.addVertex(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[2]).setUv2(lightmapX, lightmapY);
                        builder.addVertex(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[3]).setUv2(lightmapX, lightmapY);
                        builder.addVertex(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[3]).setUv2(lightmapX, lightmapY);
                        builder.addVertex(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[2]).setUv2(lightmapX, lightmapY);
                        ++gf;
                    }
                } else {
                    uvs = GifLoader.getUVFromGIF((long)gif_frame, gif_first);
                    builder.addVertex(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[2]).setUv2(lightmapX, lightmapY);
                    builder.addVertex(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[3]).setUv2(lightmapX, lightmapY);
                    builder.addVertex(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[3]).setUv2(lightmapX, lightmapY);
                    builder.addVertex(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[2]).setUv2(lightmapX, lightmapY);
                }
            } else {
                builder.addVertex(positionMatrix, -0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[2]).setUv2(lightmapX, lightmapY);
                builder.addVertex(positionMatrix, -0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[0], uvs[3]).setUv2(lightmapX, lightmapY);
                builder.addVertex(positionMatrix, 0.5f * size, 0.0f, 0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[3]).setUv2(lightmapX, lightmapY);
                builder.addVertex(positionMatrix, 0.5f * size, 0.0f, -0.5f * size).setColor(r, g, b, a).setUv(uvs[1], uvs[2]).setUv2(lightmapX, lightmapY);
            }
            if (enchant) {
                ((MultiBufferSource.BufferSource)buffer).endBatch(type);
            }
        }
        matrix.translate(0.0, Math.sin(EffectUtil.toRad(ringangle)) / 2.0 * (double)height, 0.0);
        positionMatrix = matrix.last().pose();
        loadImage = rune;
        if (showRing) {
            if (loadImage >= 0) {
                for (int j = 0; j < MTConfig.MAGIC_RUNES.size(); ++j) {
                    ClientImageDownloadUtil.download("runes" + j, MTConfig.MAGIC_RUNES.get(j), true);
                }
                if (loadImage < ClientImageDownloadUtil.lstRunes.size()) {
                    try {
                        type = MahoujinRenderType.createRunesRenderType(ClientImageDownloadUtil.lstRunes.get(loadImage), rindex);
                    }
                    catch (Exception e) {
                        type = MahoujinRenderType.createRunesRenderType(runes, rindex);
                    }
                } else {
                    type = MahoujinRenderType.createRunesRenderType(runes, rindex);
                }
            } else {
                type = MahoujinRenderType.createRunesRenderType(runes, rindex);
            }
            ProjectorRenderer.renderRing(positionMatrix, 0.0, ring, size / 2.0f + 0.125f, height, 128, buffer, lightmapX, lightmapY, r, g, b, a, type);
            if (enchant) {
                ((MultiBufferSource.BufferSource)buffer).endBatch(type);
            }
        }
        matrix.popPose();
    }

    public static void renderRing(Matrix4f matrix4f, double cy, float flatness, float radius, float height, int num_segments, MultiBufferSource buf, int lx, int ly, float r, float g, float b, float a, RenderType rt) {
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        VertexConsumer buffer = buf.getBuffer(rt);
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                buffer.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(lx, ly);
                buffer.addVertex(matrix4f, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(lx, ly);
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            buffer.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(r, g, b, a).setUv(texx, 0.0f).setUv2(lx, ly).setColor(r, g, b, a);
            buffer.addVertex(matrix4f, (float)xb, (float)yb, (float)zb).setColor(r, g, b, a).setUv(texx, 1.0f).setUv2(lx, ly).setColor(r, g, b, a);
        }
    }

    public static void cacheClear() {
        ClientImageDownloadUtil.lstRunes = new ArrayList();
        ClientImageDownloadUtil.lst = new ArrayList();
    }
}

