/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.util.Utils;

public class MysticCodeSwitchPacket
implements CustomPacketPayload {
    int slot;
    public static final StreamCodec<ByteBuf, MysticCodeSwitchPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, p -> p.slot, MysticCodeSwitchPacket::new);

    public MysticCodeSwitchPacket(int s) {
        this.slot = s;
    }

    public static void handle(MysticCodeSwitchPacket message, IPayloadContext context) {
        MysticCodeSwitchPacket.handleSwitch(message, context.player());
    }

    public static void handleSwitch(MysticCodeSwitchPacket message, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack != null && !stack.isEmpty() && stack.getItem() instanceof MysticCode) {
            int slot;
            MysticCode.setSlot(stack, message.slot);
            ((MysticCode)stack.getItem()).setRandomColor(stack, player.getRandom());
            ComponentItemHandler inventory = Utils.getMCInventory(stack);
            if (inventory != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3) {
                ItemStack ammo = inventory.getStackInSlot(slot);
                if (ammo.getItem() instanceof GandrSpellScroll) {
                    ((MysticCode)stack.getItem()).setColor(stack, 8);
                }
                if (ammo.getItem() instanceof FallenDownSpellScroll) {
                    ((MysticCode)stack.getItem()).setColor(stack, 9);
                }
            }
        }
    }

    public CustomPacketPayload.Type<MysticCodeSwitchPacket> type() {
        return MahouPackets.MYSTIC_CODE_SWITCH_TYPE;
    }
}

