/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.networking.MahouPackets;

public class EntityPathPacket
implements CustomPacketPayload {
    ArrayList<Integer> entities;
    ArrayList<Path> paths;
    public static final StreamCodec<ByteBuf, EntityPathPacket> STREAM_CODEC = new StreamCodec<ByteBuf, EntityPathPacket>(){

        public EntityPathPacket decode(ByteBuf buf) {
            EntityPathPacket packet = new EntityPathPacket();
            packet.decode(buf);
            return packet;
        }

        public void encode(ByteBuf buf, EntityPathPacket packet) {
            packet.encode(buf);
        }
    };

    public EntityPathPacket() {
    }

    public EntityPathPacket(ArrayList<Integer> entities, ArrayList<Path> paths) {
        this.entities = entities;
        this.paths = paths;
    }

    public void decode(ByteBuf buf) {
        int i;
        this.entities = new ArrayList();
        this.paths = new ArrayList();
        int n = buf.readInt();
        for (i = 0; i < n; ++i) {
            this.entities.add(buf.readInt());
        }
        n = buf.readInt();
        for (i = 0; i < n; ++i) {
            int points = buf.readInt();
            if (points <= 0) continue;
            Node[] p = new Node[points];
            for (int j = 0; j < points; ++j) {
                p[j] = new Node(buf.readInt(), buf.readInt(), buf.readInt());
            }
            this.paths.add(new Path(Arrays.asList(p), p[p.length - 1].asBlockPos(), false));
        }
    }

    public void encode(ByteBuf buf) {
        int i;
        buf.writeInt(this.entities.size());
        for (i = 0; i < this.entities.size(); ++i) {
            buf.writeInt(this.entities.get(i).intValue());
        }
        buf.writeInt(this.paths.size());
        for (i = 0; i < this.paths.size(); ++i) {
            int points = this.paths.get(i).getNodeCount();
            buf.writeInt(points);
            for (int j = 0; j < points; ++j) {
                Node p = this.paths.get(i).getNode(j);
                buf.writeInt(p.x);
                buf.writeInt(p.y);
                buf.writeInt(p.z);
            }
        }
    }

    public static void handle(EntityPathPacket message, IPayloadContext context) {
        ClientPacketHandler.pathHandler(message);
    }

    public CustomPacketPayload.Type<EntityPathPacket> type() {
        return MahouPackets.ENTITY_PATH_TYPE;
    }
}

