/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ForesightPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class ButterflyHitPacket
implements CustomPacketPayload {
    public static final StreamCodec<ByteBuf, ButterflyHitPacket> STREAM_CODEC = StreamCodec.unit((Object)new ButterflyHitPacket());

    public static void handle(ButterflyHitPacket message, IPayloadContext context) {
        ServerPlayer entity = (ServerPlayer)context.player();
        if (!entity.level().isClientSide && EffectUtil.hasBuff((LivingEntity)entity, ModEffects.FORESIGHT)) {
            ForesightPotion.butterflyHit((Player)entity);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ButterflyHitPacket;
    }

    public CustomPacketPayload.Type<ButterflyHitPacket> type() {
        return MahouPackets.BUTTERFLY_HIT_TYPE;
    }
}

