/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import stepsword.mahoutsukai.networking.MahouPackets;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class AuthorityStickPacket
implements CustomPacketPayload {
    boolean stick;
    public static final StreamCodec<ByteBuf, AuthorityStickPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, p -> p.stick, AuthorityStickPacket::new);

    public AuthorityStickPacket(boolean stick) {
        this.stick = stick;
    }

    public static void handle(AuthorityStickPacket message, IPayloadContext context) {
        AuthorityStickPacket.authorityStick(message, (ServerPlayer)context.player());
    }

    public static void authorityStick(AuthorityStickPacket message, ServerPlayer player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.BORROWED_AUTHORITY)) {
            if (message.stick) {
                EffectUtil.buff((LivingEntity)player, ModEffects.WALL_STICK, false, 2000);
            } else {
                EffectUtil.debuff((LivingEntity)player, ModEffects.WALL_STICK);
            }
        }
    }

    public CustomPacketPayload.Type<AuthorityStickPacket> type() {
        return MahouPackets.AUTHORITY_STICK_TYPE;
    }
}

