/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.william;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.TradeWithVillagerEvent;
import stepsword.mahoutsukai.dataattachments.worldsave.MahouSavedData;
import stepsword.mahoutsukai.datacomponents.fiction.FictionMahou;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.WilliamEntity;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.william.DictionaryDownloader;
import stepsword.mahoutsukai.item.william.WrittenEvaluation;
import stepsword.mahoutsukai.util.Utils;

public class William
extends WrittenBookItem {
    public static HashMap<BlockPos, UUID> awaitingLecterns = new HashMap();

    public William() {
        super(new Item.Properties().stacksTo(1));
    }

    public static int itemWilliamPlethora(Player player) {
        int best = 0;
        int worst = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            int mana = William.getManaValue(stack);
            if (mana > 0 && mana > best) {
                best = mana;
            }
            if (mana >= 0 || mana >= worst) continue;
            worst = mana;
        }
        return best + worst;
    }

    public static int getManaValue(ItemStack stack) {
        if (stack.is(ModItems.william)) {
            FictionMahou mahou = Utils.getFictionMahou(stack);
            int fame = mahou.getFame();
            int style = mahou.getStyle();
            return Math.max(0, fame) * style;
        }
        return 0;
    }

    public static void williamBookTraded(TradeWithVillagerEvent event) {
        String s;
        MerchantOffer offer = event.getMerchantOffer();
        MahouSavedData data = Utils.getWorldMahou(event.getEntity().level());
        Player player = event.getEntity();
        if (offer.getCostA().getItem() instanceof WrittenBookItem) {
            s = WrittenEvaluation.getBookText(offer.getCostA());
            data.addFameIfExists(offer.getCostA().getCount(), s);
        }
        if (offer.getCostB().getItem() instanceof WrittenBookItem) {
            s = WrittenEvaluation.getBookText(offer.getCostB());
            data.addFameIfExists(offer.getCostB().getCount(), s);
        }
        if (offer.getResult().getItem() instanceof WrittenBookItem) {
            s = WrittenEvaluation.getBookText(offer.getResult());
            data.addFameIfExists(offer.getResult().getCount(), s, player.getUUID());
        }
    }

    public static void createWilliamCheck(Player player) {
        if (awaitingLecterns != null) {
            Level level = player.level();
            boolean completeDicts = DictionaryDownloader.allDictionariesFinished();
            if (completeDicts) {
                ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
                for (BlockPos p : awaitingLecterns.keySet()) {
                    ItemStack out;
                    String s;
                    LecternBlockEntity lbe;
                    ItemStack stack;
                    if (!awaitingLecterns.get(p).equals(player.getUUID())) continue;
                    BlockState bs = level.getBlockState(p);
                    Block b = bs.getBlock();
                    BlockEntity be = level.getBlockEntity(p);
                    if (b == Blocks.LECTERN && ((Boolean)bs.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue() && be instanceof LecternBlockEntity && (stack = (lbe = (LecternBlockEntity)be).getBook()).getItem() == Items.WRITTEN_BOOK && !(s = WrittenEvaluation.getBookText(stack)).isEmpty() && (out = Utils.getWorldMahou(level).addPlayerFictionIfDifferent(s, awaitingLecterns.get(p), (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT), player)) != ItemStack.EMPTY) {
                        WrittenBookContent wbc = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
                        if (wbc != null) {
                            out.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)wbc.tryCraftCopy());
                        }
                        lbe.setBook(out);
                    }
                    toRemove.add(p);
                }
                for (BlockPos p : toRemove) {
                    awaitingLecterns.remove(p);
                }
            }
        }
    }

    public static void createWilliam(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity blockEntity;
        BlockPos p = event.getHitVec().getBlockPos();
        BlockState state = event.getLevel().getBlockState(p);
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (state.getBlock() == Blocks.LECTERN && (blockEntity = event.getLevel().getBlockEntity(p)) instanceof LecternBlockEntity) {
            LecternBlockEntity lbe = (LecternBlockEntity)blockEntity;
            if (stack.getItem() == Items.WRITTEN_BOOK && StrengtheningSpellEffect.getStrengthened(stack) > 0 && !lbe.hasBook()) {
                DictionaryDownloader.startAllDownloaders(a -> {});
                if (!awaitingLecterns.containsKey(p)) {
                    awaitingLecterns.put(p, player.getUUID());
                }
            }
        }
    }

    public static void updateFame(Level worldIn, ItemStack stack) {
        if (!worldIn.isClientSide && stack.getItem() instanceof WrittenBookItem) {
            FictionMahou mahou = Utils.getFictionMahou(stack);
            MahouSavedData data = Utils.getWorldMahou(worldIn);
            mahou.setFame(data.addFameIfExists(0, WrittenEvaluation.getBookText(stack)));
            Utils.setFictionMahou(stack, mahou);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        William.updateFame(worldIn, stack);
        if (player.isDiscrete() && handIn == InteractionHand.MAIN_HAND && !worldIn.isClientSide) {
            BlockHitResult result = William.getPlayerPOVHitResult((Level)worldIn, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            ItemStack r = player.getMainHandItem().copy();
            WilliamEntity william = new WilliamEntity(worldIn, player, 1.0f, r);
            BlockPos p = result.getBlockPos().relative(result.getDirection());
            william.setPos((double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5);
            worldIn.addFreshEntity((Entity)william);
            player.getMainHandItem().shrink(1);
            return InteractionResultHolder.success((Object)player.getMainHandItem());
        }
        return super.use(worldIn, player, handIn);
    }

    public static boolean isRlyeh(ItemStack stack) {
        return stack != null && stack.has(stepsword.mahoutsukai.datacomponents.DataComponents.FICTION_COMPONENT) && stack.get(stepsword.mahoutsukai.datacomponents.DataComponents.FICTION_COMPONENT) != null && ((FictionMahou)stack.get(stepsword.mahoutsukai.datacomponents.DataComponents.FICTION_COMPONENT)).style < 0;
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        super.onDestroyed(itemEntity, damageSource);
        if (damageSource.is(DamageTypes.ON_FIRE) || damageSource.is(DamageTypes.IN_FIRE) || damageSource.is(DamageTypes.LAVA)) {
            // empty if block
        }
    }
}

