/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret.ripper;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.effects.exchange.ImmunityExchangeSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.networking.FogPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TheRipper
extends ItemBase {
    public TheRipper() {
        super("theripper", 1, MTConfig.RIPPER_DURABILITY);
    }

    public static void adjustAttributeModifiers(ItemAttributeModifierEvent event) {
        if (event.getItemStack().getItem() instanceof TheRipper) {
            event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, MTConfig.RIPPER_DAMAGE, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            event.replaceModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, MTConfig.RIPPER_DAMAGE, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.OFFHAND);
            event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, MTConfig.RIPPER_SPEED, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            event.replaceModifier(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, MTConfig.RIPPER_SPEED, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.OFFHAND);
            event.addModifier(Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"ripper_move_speed"), MTConfig.RIPPER_MOVEMENT_SPEED, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player != null) {
            int manafog;
            Player target = player;
            ItemStack main = player.getItemBySlot(EquipmentSlot.MAINHAND);
            ItemStack off = player.getItemBySlot(EquipmentSlot.OFFHAND);
            if (!player.level().isClientSide && main.getItem() == off.getItem() && main.getItem() == ModItems.theripper.get() && MTConfig.RIPPER_GIVES_INVIS && PlayerManaManager.drainMana(player, manafog = MTConfig.RIPPER_INVIS_MANA_COST, false, false) == manafog) {
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_INVISIBILITY, false, 2000000000, false);
                RipperInvisPotion.notifyIfInvisible((LivingEntity)player);
            }
            int mana = MTConfig.RIPPER_FOG_MANA_COST;
            if (!player.level().isClientSide && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN) && PlayerManaManager.drainMana(player, mana, false, false) == mana) {
                LivingEntity look = ImmunityExchangeSpellEffect.getEnemy(player);
                if (look != null) {
                    target = look;
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN, false, MTConfig.RIPPER_COOLDOWN, false);
                PacketHandler.sendTracking((Entity)target, new FogPacket(target.getId(), MTConfig.RIPPER_FOG_RANGE, MTConfig.RIPPER_FOG_DISTANCE));
                if (target instanceof ServerPlayer) {
                    PacketHandler.sendTo((ServerPlayer)target, new FogPacket(target.getId(), 20.0, 5.0));
                }
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)ItemStack.EMPTY);
    }

    public static void ripperOnHit(LivingIncomingDamageEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getMainHandItem().getItem() == living.getOffhandItem().getItem() && living.getOffhandItem().getItem() == ModItems.theripper.get()) {
            if (EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY) && MTConfig.RIPPER_GIVES_INVIS) {
                EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
                RipperInvisPotion.notifyNotInvisible(living);
                EffectUtil.buff(living, ModEffects.RIPPER_INVIS_COOLDOWN, false, MTConfig.RIPPER_INVIS_COOLDOWN, false);
            }
            if (!EffectUtil.isLookingAtMe(living, event.getEntity())) {
                IMahou mahou;
                event.getEntity().invulnerableTime = 0;
                int mm = 100;
                if (living instanceof Player && (mahou = Utils.getPlayerMahou((Player)living)) != null) {
                    mm = mahou.getMaxMana();
                }
                double d = MTConfig.RIPPER_DAMAGE_BONUS_FROM_BEHIND * (double)(MTConfig.RIPPER_DAMAGE_BONUS_SCALES_WITH_MANA ? mm : 1);
                d = (double)event.getAmount() + d;
                event.setAmount((float)d);
            }
        }
    }

    public static void ripperLivingTick(LivingEntity living) {
        if (living != null && (living.getMainHandItem().getItem() != living.getOffhandItem().getItem() || living.getMainHandItem().getItem() != ModItems.theripper.get()) && EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY)) {
            EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
            RipperInvisPotion.notifyNotInvisible(living);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RIPPER_DURABILITY;
    }

    public static void attack(Player player, Entity pTarget) {
        if (!CommonHooks.onPlayerAttackTarget((Player)player, (Entity)pTarget)) {
            return;
        }
        if (pTarget.isAttackable() && !pTarget.skipAttackInteraction((Entity)player)) {
            Projectile projectile;
            float f = player.isAutoSpinAttack() ? player.autoSpinAttackDmg : (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            ItemStack itemstack = player.getWeaponItem();
            DamageSource damagesource = player.damageSources().playerAttack(player);
            float f1 = player.getEnchantedDamage(pTarget, f, damagesource) - f;
            float f2 = player.getAttackStrengthScale(0.5f);
            f *= 0.2f + f2 * f2 * 0.8f;
            f1 *= f2;
            if (pTarget.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && pTarget instanceof Projectile && (projectile = (Projectile)pTarget).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource());
                return;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean flag4;
                boolean bl = flag4 = f2 > 0.9f;
                if (player.isSprinting() && flag4) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, player.getSoundSource(), 1.0f, 1.0f);
                    flag = true;
                } else {
                    flag = false;
                }
                f += itemstack.getItem().getAttackDamageBonus(pTarget, f, damagesource);
                boolean flag1 = flag4 && player.fallDistance > 0.0f && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.hasEffect(MobEffects.BLINDNESS) && !player.isPassenger() && pTarget instanceof LivingEntity && !player.isSprinting();
                CriticalHitEvent critEvent = CommonHooks.fireCriticalHit((Player)player, (Entity)pTarget, (boolean)flag1, (float)(flag1 ? 1.5f : 1.0f));
                flag1 = critEvent.isCriticalHit();
                if (flag1) {
                    f *= critEvent.getDamageMultiplier();
                }
                float f3 = f + f1;
                boolean flag2 = false;
                double d0 = player.walkDist - player.walkDistO;
                if (flag4 && !flag1 && !flag && player.onGround() && d0 < (double)player.getSpeed()) {
                    ItemStack itemstack1 = player.getItemInHand(InteractionHand.MAIN_HAND);
                    flag2 = itemstack1.canPerformAction(ItemAbilities.SWORD_SWEEP);
                }
                float f6 = 0.0f;
                if (pTarget instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)pTarget;
                    f6 = livingentity.getHealth();
                }
                Vec3 vec3 = pTarget.getDeltaMovement();
                boolean flag3 = pTarget.hurt(damagesource, f3);
                if (flag3) {
                    float f4 = player.getKnockback(pTarget, damagesource) + (flag ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (pTarget instanceof LivingEntity) {
                            LivingEntity livingentity1 = (LivingEntity)pTarget;
                            livingentity1.knockback((double)(f4 * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            pTarget.push((double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f), 0.1, (double)(Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f));
                        }
                        player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        player.setSprinting(false);
                    }
                    if (flag2) {
                        float f7 = 1.0f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * f;
                        for (LivingEntity livingentity2 : player.level().getEntitiesOfClass(LivingEntity.class, pTarget.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                            double entityReachSq = Mth.square((double)player.entityInteractionRange());
                            if (livingentity2 == player || livingentity2 == pTarget || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq)) continue;
                            float f5 = player.getEnchantedDamage((Entity)livingentity2, f7, damagesource) * f2;
                            livingentity2.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                            livingentity2.hurt(damagesource, f5);
                            Level level = player.level();
                            if (!(level instanceof ServerLevel)) continue;
                            ServerLevel serverlevel = (ServerLevel)level;
                            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
                        }
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                        player.sweepAttack();
                    }
                    if (pTarget instanceof ServerPlayer && pTarget.hurtMarked) {
                        ((ServerPlayer)pTarget).connection.send((Packet)new ClientboundSetEntityMotionPacket(pTarget));
                        pTarget.hurtMarked = false;
                        pTarget.setDeltaMovement(vec3);
                    }
                    if (flag1) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
                        player.crit(pTarget);
                    }
                    if (!flag1 && !flag2) {
                        if (flag4) {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, player.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, player.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.magicCrit(pTarget);
                    }
                    player.setLastHurtMob(pTarget);
                    Entity entity = pTarget;
                    if (pTarget instanceof PartEntity) {
                        entity = ((PartEntity)pTarget).getParent();
                    }
                    boolean flag5 = false;
                    ItemStack copy = itemstack.copy();
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel1 = (ServerLevel)level;
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingentity3 = (LivingEntity)entity;
                            flag5 = itemstack.hurtEnemy(livingentity3, player);
                        }
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)pTarget, (DamageSource)damagesource);
                    }
                    if (!player.level().isClientSide && !itemstack.isEmpty() && entity instanceof LivingEntity) {
                        if (flag5) {
                            itemstack.postHurtEnemy((LivingEntity)entity, player);
                        }
                        if (itemstack.isEmpty()) {
                            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)(itemstack == player.getMainHandItem() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
                            if (itemstack == player.getMainHandItem()) {
                                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                            } else {
                                player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            }
                        }
                    }
                    if (pTarget instanceof LivingEntity) {
                        float f8 = f6 - ((LivingEntity)pTarget).getHealth();
                        player.awardStat(Stats.DAMAGE_DEALT, Math.round(f8 * 10.0f));
                        if (player.level() instanceof ServerLevel && f8 > 2.0f) {
                            int i = (int)((double)f8 * 0.5);
                            ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, pTarget.getX(), pTarget.getY(0.5), pTarget.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.causeFoodExhaustion(0.1f);
                } else {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
                }
            }
            player.resetAttackStrengthTicker();
        }
    }
}

