/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.ProximityProjection;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.GrowSwordItem;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class ProximityProjectionKeys
extends ItemBase {
    public ProximityProjectionKeys() {
        super("proximity_projection_keys", new Item.Properties().attributes(GrowSwordItem.createAttributes((int)(3.0f + Tiers.IRON.getAttackDamageBonus()), -2.4f)).stacksTo(1).durability(MTConfig.PROXIMITY_PROJECTION_DURABILITY));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        return Items.IRON_SWORD.isPrimaryItemFor(new ItemStack((ItemLike)Items.IRON_SWORD), enchantment);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 15;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        Block block = state.getBlock();
        if (block == Blocks.COBWEB) {
            return 15.0f;
        }
        return 1.0f;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (!attacker.level().isClientSide && attacker instanceof Player) {
            BlockPos pos = target.blockPosition();
            attacker.stopRiding();
            ((ServerPlayer)attacker).connection.teleport((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), attacker.yRot, attacker.xRot);
            MahouTsukaiTeleporter.teleport((Entity)attacker, pos.getX(), pos.getY(), pos.getZ(), EffectUtil.getDimension(attacker.level()));
        }
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.getDestroySpeed((BlockGetter)worldIn, pos) != 0.0) {
            stack.hurtAndBreak(2, entityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public int getEnchantmentValue() {
        return Tiers.IRON.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public static Predicate<Entity> getProximityLookPredicate() {
        return new Predicate<Entity>(){

            public boolean apply(@Nullable Entity e) {
                return e instanceof LivingEntity;
            }
        };
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.PROXIMITY_PROJECTION_DURABILITY;
    }
}

