/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.datacomponents.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class CupOfHeavenSpellScroll
extends SpellScroll {
    public CupOfHeavenSpellScroll() {
        super("cup_of_heaven");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.HEAVENS_CUP_MANA_COST;
    }

    @Override
    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        ScrollMahou scrollMahou;
        Player user;
        if (!worldIn.isClientSide && entityLiving instanceof Player && CupOfHeavenSpellScroll.matchCaster(user = (Player)entityLiving, scrollMahou = Utils.getScrollMahou(stack))) {
            this.doSpell(user, scrollMahou, stack, consume);
        }
    }

    public boolean doSpell(Player user, ScrollMahou scrollMahou, ItemStack stack, boolean consume) {
        IMahou mahou;
        if (scrollMahou != null && (mahou = Utils.getPlayerMahou(user)) != null) {
            double d = MTConfig.HEAVENS_CUP_START_DISTANCE;
            double minD = d * d * 4.0;
            CupOfHeavenMahoujinTileEntity start = null;
            Vec3 v = user.position();
            ArrayList<BlockPos> lst2 = Utils.findTilesInRange((LivingEntity)user, (int)d, a -> a instanceof CupOfHeavenMahoujinTileEntity);
            for (BlockPos p : lst2) {
                double curr;
                CupOfHeavenMahoujinTileEntity mte;
                BlockEntity te = user.level().getBlockEntity(p);
                if (!(te instanceof CupOfHeavenMahoujinTileEntity) || (mte = (CupOfHeavenMahoujinTileEntity)te).getCasterUUID() == null || !mte.getCasterUUID().equals(user.getUUID()) || !((curr = CupOfHeavenSpellScroll.distanceTo(p, v, d * d * 4.0)) < minD)) continue;
                minD = curr;
                start = mte;
            }
            if (start != null) {
                start.buildNetwork(user.getUUID(), network -> {
                    if (network.size() > 2) {
                        int e;
                        final List<BlockPos> hull = CupOfHeavenSpellScroll.convexHull(network);
                        int internal = network.size() - hull.size();
                        BlockPos minZ = null;
                        BlockPos minX = null;
                        BlockPos maxX = null;
                        BlockPos maxZ = null;
                        for (BlockPos p : network) {
                            if (minX == null || minX.getX() > p.getX()) {
                                minX = p;
                            }
                            if (maxX == null || maxX.getX() < p.getX()) {
                                maxX = p;
                            }
                            if (minZ == null || minZ.getZ() > p.getZ()) {
                                minZ = p;
                            }
                            if (maxZ != null && maxZ.getZ() >= p.getZ()) continue;
                            maxZ = p;
                        }
                        final double maxx = maxX.getX();
                        AABB aabb = new AABB(new BlockPos(minX.getX(), user.level().getMinBuildHeight(), minZ.getZ()).getCenter(), new BlockPos(maxX.getX(), user.level().getMaxBuildHeight(), maxZ.getZ()).getCenter());
                        List affected = user.level().getEntitiesOfClass(LivingEntity.class, aabb, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                            public boolean apply(@Nullable LivingEntity input) {
                                return input != null && CupOfHeavenSpellScroll.isInside(hull, input.position(), maxx);
                            }
                        });
                        int duration = MTConfig.HEAVENS_CUP_DURATION;
                        int g = internal;
                        int external = hull.size();
                        List<? extends String> effects = MTConfig.HEAVENS_CUP_EFFECTS;
                        int[] aa = new int[effects.size()];
                        for (e = 0; e < effects.size(); ++e) {
                            aa[e] = 0;
                            while (internal % Utils.primes[e] == 0 && internal > 0) {
                                int n = e;
                                aa[n] = aa[n] + 1;
                                internal /= Utils.primes[e];
                            }
                        }
                        for (e = 0; e < effects.size(); ++e) {
                            while (external % Utils.primes[e] == 0 && external > 0) {
                                int n = e;
                                aa[n] = aa[n] + 1;
                                external /= Utils.primes[e];
                            }
                        }
                        int manacost = 0;
                        for (int p = 0; p < aa.length; ++p) {
                            manacost += aa[p] * Utils.primes[p];
                        }
                        manacost = (int)((double)manacost * Math.ceil(Math.sqrt((maxZ.getZ() - minZ.getZ()) * (maxX.getX() - minX.getX()))));
                        if (PlayerManaManager.drainMana(user, manacost *= MTConfig.HEAVENS_CUP_MANA_COST, false, false) == manacost) {
                            int aq;
                            for (LivingEntity a : affected) {
                                for (aq = 0; aq < aa.length; ++aq) {
                                    if (aa[aq] <= 0) continue;
                                    a.addEffect(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(effects.get(aq)), duration, aa[aq] - 1));
                                }
                            }
                            boolean allzero = true;
                            boolean allnotzero = true;
                            for (aq = 0; aq < aa.length; ++aq) {
                                if (aa[aq] > 0) {
                                    allzero = false;
                                }
                                if (aa[aq] > 0) continue;
                                allnotzero = false;
                            }
                            if (allnotzero && aa.length > 0) {
                                ((MahouTrigger)((Object)((Object)ModTriggers.GREATER_GRAIL.get()))).trigger((ServerPlayer)user);
                                user.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.AQUA) + "Greater Grail found. External size: " + hull.size() + ". Internal size: " + g)), true);
                            } else if (allzero && aa.length > 0) {
                                user.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Lesser Grail found, but internal count is imbalanced. External size: " + hull.size() + ". Internal size: " + g)), true);
                            } else if (aa.length > 0) {
                                ((MahouTrigger)((Object)((Object)ModTriggers.LESSER_GRAIL.get()))).trigger((ServerPlayer)user);
                                user.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Lesser Grail found. External size: " + hull.size() + ". Internal size: " + g)), true);
                            }
                            this.deleteScroll(true, user, consume, stack);
                        } else {
                            user.displayClientMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Not enough mana to activate grail. External size: " + hull.size() + ". Internal size: " + g + ". Mana needed: " + manacost + ".")), true);
                        }
                    }
                });
            } else {
                return false;
            }
        }
        return false;
    }

    public void deleteScroll(boolean doSpell, Player user, boolean consume, ItemStack stack) {
        if (doSpell && (!user.isCreative() || MTConfig.CREATIVE_MODE_SPELLS) && consume) {
            stack.shrink(1);
        }
    }

    public static boolean onSegment(BlockPos p, Vec3 q, BlockPos r) {
        BlockPos bpq = Utils.toBlockPos(q);
        return bpq.getX() <= Math.max(p.getX(), r.getX()) && bpq.getX() >= Math.min(p.getX(), r.getX()) && bpq.getZ() <= Math.max(p.getZ(), r.getZ()) && bpq.getZ() >= Math.min(p.getZ(), r.getZ());
    }

    static boolean isInside(List<BlockPos> polygon, Vec3 p, double maxX) {
        int next;
        if (polygon.size() < 2) {
            return false;
        }
        if (polygon.size() == 2) {
            return CupOfHeavenSpellScroll.onSegment(polygon.get(0), p, polygon.get(1).offset(1, 0, 1));
        }
        Vec3 extreme = new Vec3(maxX + 5000000.0, 0.0, p.z);
        int count = 0;
        int i = 0;
        do {
            next = (i + 1) % polygon.size();
            if (!CupOfHeavenSpellScroll.doIntersect(EffectUtil.fromBlockPos(polygon.get(i)), EffectUtil.fromBlockPos(polygon.get(next)), p, extreme)) continue;
            if (CupOfHeavenSpellScroll.orientation(EffectUtil.fromBlockPos(polygon.get(i)), p, EffectUtil.fromBlockPos(polygon.get(next))) == 0) {
                return CupOfHeavenSpellScroll.onSegment(polygon.get(i), p, polygon.get(next));
            }
            ++count;
        } while ((i = next) != 0);
        return count % 2 == 1;
    }

    public static double distanceTo(BlockPos from, Vec3 to, double d) {
        if (from != null && to != null) {
            BlockPos a = new BlockPos(from.getX(), 0, from.getZ());
            return a.distToCenterSqr(to.x, 0.0, to.z);
        }
        return d;
    }

    public static List<BlockPos> convexHull(HashSet<BlockPos> ps) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        ArrayList<Vec3> pts = new ArrayList<Vec3>();
        Object minV = null;
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        boolean found = false;
        for (BlockPos p : ps) {
            found = false;
            for (BlockPos z : points) {
                if (z.getZ() != p.getZ() || z.getX() != p.getX()) continue;
                found = true;
            }
            if (found) continue;
            points.add(p);
        }
        for (BlockPos p : points) {
            Vec3 tmpV = EffectUtil.fromBlockPos(p);
            pts.add(tmpV);
        }
        pts.sort((a, b) -> {
            if (a.z == b.z) {
                if (a.x > b.x) {
                    return -1;
                }
                if (a.x < b.x) {
                    return 1;
                }
                return 0;
            }
            if (a.z < b.z) {
                return -1;
            }
            if (a.z > b.z) {
                return 1;
            }
            return 0;
        });
        Vec3 initial = (Vec3)pts.get(0);
        pts.remove(initial);
        if (initial != null) {
            pts.sort((a, b) -> {
                double cross = (a.x - initial.x) * (b.z - initial.z) - (b.x - initial.x) * (a.z - initial.z);
                if (cross > 0.0) {
                    return 1;
                }
                if (cross < 0.0) {
                    return -1;
                }
                double adist = (a.x - initial.x) * (a.x - initial.x) + (a.z - initial.z) * (a.z - initial.z);
                double bdist = (b.x - initial.x) * (b.x - initial.x) + (b.z - initial.z) * (b.z - initial.z);
                if (adist < bdist) {
                    return 1;
                }
                if (adist > bdist) {
                    return -1;
                }
                return 0;
            });
        }
        for (int m = 1; m < pts.size(); ++m) {
            Vec3 a2 = (Vec3)pts.get(m);
            Vec3 b2 = (Vec3)pts.get(m - 1);
            double cross = (a2.x - initial.x) * (b2.z - initial.z) - (b2.x - initial.x) * (a2.z - initial.z);
            double cotanA = -(a2.x - initial.x) / (a2.z - initial.z);
            double cotanB = -(b2.x - initial.x) / (b2.z - initial.z);
            if (cross != 0.0) continue;
            pts.remove(m);
            --m;
        }
        Stack<Vec3> stack = new Stack<Vec3>();
        stack.push(initial);
        for (Vec3 pt : pts) {
            while (stack.size() > 1 && CupOfHeavenSpellScroll.ccw(CupOfHeavenSpellScroll.nextToTop(stack), stack.peek(), pt) <= 0) {
                stack.pop();
            }
            stack.push(pt);
        }
        while (!stack.empty()) {
            Vec3 tmp = (Vec3)stack.pop();
            ret.add(Utils.toBlockPos(tmp.x, tmp.y, tmp.z));
        }
        return ret;
    }

    public static Vec3 nextToTop(Stack<Vec3> s) {
        Vec3 tmp = s.pop();
        Vec3 ret = s.peek();
        s.push(tmp);
        return ret;
    }

    public static int ccw(Vec3 a, Vec3 b, Vec3 c) {
        double area2 = (-b.x + a.x) * (c.z - a.z) - (b.z - a.z) * (-c.x + a.x);
        double ball = 1.0E-7;
        if (area2 < ball && area2 > 0.0) {
            return 0;
        }
        if (area2 > -ball && area2 < 0.0) {
            return 0;
        }
        if (area2 < 0.0) {
            return -1;
        }
        if (area2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public static boolean doIntersect(Vec3 p1, Vec3 q1, Vec3 p2, Vec3 q2) {
        int o1 = CupOfHeavenSpellScroll.orientation(p1, q1, p2);
        int o2 = CupOfHeavenSpellScroll.orientation(p1, q1, q2);
        int o3 = CupOfHeavenSpellScroll.orientation(p2, q2, p1);
        int o4 = CupOfHeavenSpellScroll.orientation(p2, q2, q1);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && CupOfHeavenSpellScroll.onSegment(Utils.toBlockPos(p1), p2, Utils.toBlockPos(q1))) {
            return true;
        }
        if (o2 == 0 && CupOfHeavenSpellScroll.onSegment(Utils.toBlockPos(p1), q2, Utils.toBlockPos(q1))) {
            return true;
        }
        if (o3 == 0 && CupOfHeavenSpellScroll.onSegment(Utils.toBlockPos(p2), p1, Utils.toBlockPos(q2))) {
            return true;
        }
        return o4 == 0 && CupOfHeavenSpellScroll.onSegment(Utils.toBlockPos(p2), q1, Utils.toBlockPos(q2));
    }

    public static int orientation(Vec3 p, Vec3 q, Vec3 r) {
        double val = (q.z - p.z) * (-r.x + q.x) - (-q.x + p.x) * (r.z - q.z);
        if (val == 0.0) {
            return 0;
        }
        return val > 0.0 ? 1 : 2;
    }

    private static Holder<MobEffect> getRegisteredMobEffect(String id) {
        Holder potion = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)id)).orElseThrow();
        return potion;
    }
}

