/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.clarent;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.sword.SwordMahou;
import stepsword.mahoutsukai.item.GrowSwordItem;
import stepsword.mahoutsukai.util.Utils;

public class Clarent
extends GrowSwordItem {
    protected String name;
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_clarent_attack";

    public Clarent() {
        super((Tier)Tiers.IRON, 1.0f, 10, MTConfig.CLARENT_DURABILITY);
    }

    public static float calculateDamageFromWeapon(ItemStack s) {
        float r = 1.0f;
        ItemAttributeModifiers map = s.getAttributeModifiers();
        float d = 1.0f;
        for (ItemAttributeModifiers.Entry me : map.modifiers()) {
            if (!me.attribute().is(Attributes.ATTACK_DAMAGE)) continue;
            AttributeModifier m = me.modifier();
            if (m.operation() == AttributeModifier.Operation.ADD_VALUE) {
                r = (float)((double)r + m.amount());
            }
            d = r;
            if (m.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE) {
                d = (float)((double)d + (double)r * m.amount());
            }
            if (m.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) continue;
            d = (float)((double)d * (1.0 + m.amount()));
        }
        return d;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            player.startUsingItem(handIn);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(handIn));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity player, int cnt) {
        if (!world.isClientSide) {
            SwordMahou mahou = Utils.getSwordMahou(stack);
            if (mahou == null) {
                mahou = new SwordMahou();
            }
            mahou.setAttackDamage(Math.min((float)MTConfig.CLARENT_ATTACK_CAP, Math.max(0.0f, mahou.getAttackDamage() - (float)(this.getUseDuration(stack, player) - cnt) * (float)MTConfig.CLARENT_DECREASE_PER_BLOCKING_TICK)));
            Utils.setSwordMahou(stack, mahou);
        }
        super.releaseUsing(stack, world, player, cnt);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (toolAction == ItemAbilities.SHIELD_BLOCK) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.CLARENT_DURABILITY;
    }
}

