/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration.emi;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.render.RenderUtils;

public class EntityEmiStack
extends EmiStack
implements EmiRenderable {
    public ResourceLocation loc;
    public Component name;
    Entity entity;

    public EntityEmiStack(ResourceLocation loc, Entity entity) {
        this.loc = loc;
        this.name = entity.getName();
        this.entity = entity;
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v) {
        this.render(guiGraphics, i, i1, guiGraphics.pose(), this.entity);
    }

    public void render(GuiGraphics guiGraphics, int i, int i1, float v, int i2) {
        this.render(guiGraphics, i, i1, guiGraphics.pose(), this.entity);
    }

    public EmiStack copy() {
        return new EntityEmiStack(this.loc, this.entity);
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return ModBlocks.mahoujinBlockItem;
    }

    public ResourceLocation getId() {
        return this.loc;
    }

    public ItemStack getItemStack() {
        return ItemStack.EMPTY;
    }

    public boolean isEqual(EmiStack stack) {
        return stack.getId().equals((Object)this.getId());
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        if (!this.isEmpty()) {
            Minecraft client = Minecraft.getInstance();
            String mod = this.getModName(this.getId().getNamespace());
            list.add(new ClientTextTooltip(Component.literal((String)mod).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}).getVisualOrderText()));
            list.addFirst(new ClientTextTooltip(this.getName().getVisualOrderText()));
        }
        return list;
    }

    public String getModName(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = ModList.get().getModContainerById(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        container = ModList.get().getModContainerById(namespace.replace('_', '-'));
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getModInfo().getDisplayName();
        }
        return WordUtils.capitalizeFully((String)namespace.replace('_', ' '));
    }

    public List<Component> getTooltipText() {
        return List.of(this.getName());
    }

    public Component getName() {
        return this.name;
    }

    public void render(GuiGraphics graphics, int pX, int pY, PoseStack pPoseStack, Entity entity) {
        pPoseStack.pushPose();
        pPoseStack.translate(-0.5f, -0.5f, 2.5f);
        pPoseStack.translate((float)(pX + 8), (float)(pY + 14), 0.0f);
        graphics.pose().scale(16.0f, -16.0f, 16.0f);
        graphics.pose().scale(0.75f, 0.75f, 0.75f);
        RenderUtils.rotateQ(30.0f, 1.0f, 0.0f, 0.0f, pPoseStack);
        RenderUtils.rotateQ(-45.0f, 0.0f, 1.0f, 0.0f, pPoseStack);
        EntityEmiStack.renderEntityInInventoryFollowsAngle(graphics, 1, entity);
        pPoseStack.popPose();
    }

    public static void renderEntityInInventoryFollowsAngle(GuiGraphics p_282802_, int p_294663_, Entity entity) {
        Quaternionf quaternionf = new Quaternionf();
        Quaternionf quaternionf1 = new Quaternionf();
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f9 = entity.getBbHeight();
        float f10 = Math.min((float)p_294663_ / f9, 1.0f);
        EntityEmiStack.renderEntityInInventory(p_282802_, f10, quaternionf, quaternionf1, entity);
    }

    public static void renderEntityInInventory(GuiGraphics pGuiGraphics, float pScale, Quaternionf pPose, @Nullable Quaternionf pCameraOrientation, Entity pEntity) {
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().scale(pScale, pScale, pScale);
        pGuiGraphics.pose().mulPose(pPose);
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        if (pCameraOrientation != null) {
            entityrenderdispatcher.overrideCameraOrientation(pCameraOrientation.conjugate(new Quaternionf()).rotateY((float)Math.PI));
        }
        entityrenderdispatcher.setRenderShadow(false);
        RenderSystem.runAsFancy(() -> entityrenderdispatcher.render(pEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pGuiGraphics.pose(), (MultiBufferSource)pGuiGraphics.bufferSource(), 0xF000F0));
        pGuiGraphics.flush();
        entityrenderdispatcher.setRenderShadow(true);
        pGuiGraphics.pose().popPose();
        Lighting.setupFor3DItems();
    }
}

