/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.mahoujin.GunBeamProjectileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RhoAiasMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_LOOK_VEC = "MAHOUTSUKAI_LOOK_VEC";
    public static final int loadUpTime = 20;
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 1.0E-4, 1.0E-4, 1.0E-4);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<CompoundTag> LOOK_VEC = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(RhoAiasMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public UUID casterUUID = null;
    public static final String entityName = "rho_aias_mahoujin_entity";

    public RhoAiasMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public RhoAiasMahoujinEntity(Level world) {
        super((EntityType)ModEntities.RHO_AIAS.get(), world);
        this.noCulling = true;
    }

    public RhoAiasMahoujinEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.getUUID();
        this.entityData.set(CASTER_UUID, Optional.of(this.casterUUID));
    }

    public RhoAiasMahoujinEntity(Level world, Player caster, float r, float g, float b, float a, float r2, float g2, float b2, float size) {
        this(world);
        this.casterUUID = caster.getUUID();
        this.entityData.set(CASTER_UUID, Optional.of(this.casterUUID));
        this.setColor(r, g, b, a, r2, g2, b2);
        this.angleForPlayer(caster);
        this.sizer(size);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        builder.define(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        builder.define(LIFE, (Object)0);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_R2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B2, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_A, (Object)Float.valueOf(0.0f));
        builder.define(DISTANCE, (Object)Float.valueOf(0.0f));
        builder.define(LOOK_VEC, (Object)new CompoundTag());
        builder.define(CASTER_UUID, Optional.empty());
    }

    public float getSphereMidRadius() {
        float sphereMidRadius = 7.8f;
        return sphereMidRadius;
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(0.0, 0.0, 0.0);
        try {
            if (this.casterUUID == null) {
                this.casterUUID = (UUID)((Optional)this.entityData.get(CASTER_UUID)).get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.yRotO = this.yRot;
        if (this.yRotO < 0.0f) {
            this.yRotO += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.yRot = this.getRotationYaw();
        this.xRot = this.getRotationPitch();
        this.setRot(this.yRot, this.xRot);
        if (!this.level().isClientSide) {
            this.setLife(this.getLife() + 1);
            if (this.casterUUID == null) {
                this.discard();
            } else {
                Player caster = this.level().getPlayerByUUID(this.casterUUID);
                if (caster == null || !caster.isAlive()) {
                    this.discard();
                }
            }
            if (this.getLife() >= MTConfig.RHO_AIAS_LIFE) {
                this.discard();
            }
        }
        this.projectileDeletion();
        this.collideWithNearbyEntities();
    }

    public boolean isPickable() {
        return false;
    }

    public void playerTouch(Player entityIn) {
        if (!entityIn.getUUID().equals(this.casterUUID)) {
            // empty if block
        }
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.entityData.set(COLOR_R2, (Object)Float.valueOf(r2));
        this.entityData.set(COLOR_G2, (Object)Float.valueOf(g2));
        this.entityData.set(COLOR_B2, (Object)Float.valueOf(b2));
        this.entityData.set(COLOR_A, (Object)Float.valueOf(a));
    }

    protected void checkInsideBlocks() {
    }

    @Nullable
    public AABB getBoundingBox() {
        return ZERO_AABB;
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue(), ((Float)this.entityData.get(COLOR_A)).floatValue(), ((Float)this.entityData.get(COLOR_R2)).floatValue(), ((Float)this.entityData.get(COLOR_G2)).floatValue(), ((Float)this.entityData.get(COLOR_B2)).floatValue()};
    }

    public void angleForPlayer(Player user) {
        Vec3 vec = user.getLookAngle().normalize().scale(5.0);
        this.setLookV(user.getLookAngle().normalize());
        Vec3 eyes = user.getEyePosition(1.0f);
        this.setPos(eyes.x + vec.x, eyes.y + vec.y, eyes.z + vec.z);
        double theta = Math.asin(vec.y / 5.0);
        theta = RhoAiasMahoujinEntity.fromRad(theta);
        this.setRotationPitch((float)(90.0 - theta));
        this.setRotationRoll(360.0f - user.yRot);
    }

    public static double fromRad(double rad) {
        return rad * 57.2957795131;
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void collideWithNearbyEntities() {
        float size = this.getCircleSize();
        AABB maabb = new AABB(this.getX() - (double)size, this.getY() - (double)size, this.getZ() - (double)size, this.getX() + (double)size, this.getY() + (double)size, this.getZ() + (double)size);
        List list = this.level().getEntities((Entity)this, maabb.inflate(2.0), Entity::isAlive);
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                int collide;
                Entity entity = (Entity)list.get(l);
                try {
                    if (MTConfig.RHO_AIAS_SNEAK_BOOP && entity.getUUID().equals(((Optional)this.entityData.get(CASTER_UUID)).get()) && !entity.isDiscrete()) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ((collide = this.doesItCollide(entity)) == 3 || collide == 1) {
                    this.collideWithEntity(entity);
                    continue;
                }
                if (collide != 0) continue;
            }
        }
    }

    public int doesItCollide(Entity entity) {
        AABB aabb = entity.getBoundingBox();
        boolean flag = false;
        boolean flag1 = false;
        if (aabb != null) {
            Vec3 a1 = new Vec3(aabb.minX, aabb.minY, aabb.minZ);
            Vec3 a2 = new Vec3(aabb.minX, aabb.minY, aabb.maxZ);
            Vec3 a3 = new Vec3(aabb.maxX, aabb.minY, aabb.minZ);
            Vec3 a4 = new Vec3(aabb.maxX, aabb.minY, aabb.maxZ);
            Vec3 b1 = new Vec3(aabb.minX, aabb.maxY, aabb.minZ);
            Vec3 b2 = new Vec3(aabb.minX, aabb.maxY, aabb.maxZ);
            Vec3 b3 = new Vec3(aabb.maxX, aabb.maxY, aabb.minZ);
            Vec3 b4 = new Vec3(aabb.maxX, aabb.maxY, aabb.maxZ);
            int f1 = this.whereIsPoint(a1);
            int f2 = this.whereIsPoint(a2);
            int f3 = this.whereIsPoint(a3);
            int f4 = this.whereIsPoint(a4);
            int f5 = this.whereIsPoint(b1);
            int f6 = this.whereIsPoint(b2);
            int f7 = this.whereIsPoint(b3);
            int f8 = this.whereIsPoint(b4);
            flag = f1 == 1 || f2 == 1 || f3 == 1 || f4 == 1 || f5 == 1 || f6 == 1 || f7 == 1 || f8 == 1;
            boolean bl = flag1 = f1 == 2 || f2 == 2 || f3 == 2 || f4 == 2 || f5 == 2 || f6 == 2 || f7 == 2 || f8 == 2;
        }
        if (flag && flag1) {
            return 3;
        }
        if (flag) {
            return 1;
        }
        if (flag1) {
            return 2;
        }
        return 0;
    }

    public void projectileDeletion() {
        if (!this.level().isClientSide) {
            int radius = MTConfig.RHO_AIAS_KILL_RANGE;
            double posX = this.getX();
            double posY = this.getY();
            double posZ = this.getZ();
            AABB paabb = new AABB(posX - (double)radius, posY - (double)radius, posZ - (double)radius, posX + (double)radius, posY + (double)radius, posZ + (double)radius);
            List<? extends String> killList = MTConfig.RHO_AIAS_ENTITY_KILL_LIST;
            List<? extends String> collideList = MTConfig.RHO_AIAS_COLLIDE_KILL_LIST;
            if (killList.size() > 0) {
                HashSet<? extends String> set = new HashSet<String>(killList);
                HashSet<? extends String> set2 = new HashSet<String>(collideList);
                List lst = this.level().getEntitiesOfClass(Entity.class, paabb);
                for (Entity e : lst) {
                    int z;
                    if (e instanceof Player || e instanceof RhoAiasMahoujinEntity || Utils.getRegistryKey(e, this.level()) == null) continue;
                    String regname = Utils.getRegistryName(e);
                    Utils.debug("found entity near Rho Aias:" + regname);
                    if (set.contains(regname.toString())) {
                        Vec3 v = e.getDeltaMovement();
                        Vec3 p = e.position();
                        Utils.debug("found entity on kill list:" + regname + ":pos:" + p.toString() + ":vel:" + v.toString());
                        if (this.isPointInRadiusOfCircle(p.add(v)) && !this.isPointInRadiusOfCircle(p)) {
                            this.getRidOfEntity(e);
                        }
                        if (!this.isPointInRadiusOfCircle(p.add(v.scale(-1.0))) && this.isPointInRadiusOfCircle(p)) {
                            this.getRidOfEntity(e);
                        }
                    }
                    if (!set2.contains(regname) || (z = this.doesItCollide(e)) != 1 && z != 3) continue;
                    this.getRidOfEntity(e);
                }
            }
        }
    }

    public void getRidOfEntity(Entity e) {
        if (e instanceof GunBeamProjectileEntity) {
            GunBeamProjectileEntity g = (GunBeamProjectileEntity)e;
            g.specialDiscard();
        } else {
            e.discard();
        }
    }

    protected void collideWithEntity(Entity entityIn) {
        if (entityIn instanceof Arrow) {
            Arrow arrow = (Arrow)entityIn;
            if (arrow.getOwner() == null || !arrow.getOwner().getUUID().equals(this.casterUUID)) {
                arrow.setDeltaMovement(0.0, 0.0, 0.0);
                arrow.life = 3;
                arrow.yRot = this.getRotationYaw();
                arrow.xRot = this.getRotationPitch();
                arrow.hurtMarked = true;
            }
        } else if (entityIn instanceof Projectile) {
            Projectile throwable = (Projectile)entityIn;
            Entity thrower = throwable.getOwner();
            if (thrower == null || !thrower.getUUID().equals(this.casterUUID)) {
                throwable.setDeltaMovement(new Vec3(-throwable.getDeltaMovement().x, -throwable.getDeltaMovement().y, -throwable.getDeltaMovement().z));
                if (entityIn instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile e = (AbstractHurtingProjectile)throwable;
                    e.accelerationPower = -e.accelerationPower;
                }
                if (this.casterUUID != null && this.level().getPlayerByUUID(this.casterUUID) != null) {
                    throwable.setOwner((Entity)this.level().getPlayerByUUID(this.casterUUID));
                }
            }
        } else if (entityIn instanceof LivingEntity && this.getLookV() != null) {
            Vec3 v = this.getLookV();
            this.boop(entityIn, 1.0f, -v.x, -v.y, -v.z);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.hasImpulse = true;
        float f = Mth.sqrt((float)((float)(x * x + z * z + y * y)));
        Vec3 motion = this.getDeltaMovement();
        double motionX = motion.x();
        double motionY = motion.y();
        double motionZ = motion.z();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.hurtMarked = true;
        if (entity.onGround()) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.setDeltaMovement(motionX, motionY, motionZ);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setRotationYaw(compound.getFloat(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.getFloat(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.getFloat(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.getFloat(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.getFloat(TAG_CIRCLE_SIZE));
        this.setLife(compound.getInt(TAG_LIFE));
        this.casterUUID = compound.getUUID(TAG_CASTER);
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B), compound.getFloat(TAG_COLOR_A), compound.getFloat(TAG_COLOR_R2), compound.getFloat(TAG_COLOR_G2), compound.getFloat(TAG_COLOR_B2));
        this.setDistance(compound.getFloat(TAG_DISTANCE));
        CompoundTag look = compound.getCompound(TAG_LOOK_VEC);
        this.setLookV(new Vec3(look.getDouble("x"), look.getDouble("y"), look.getDouble("z")));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.putFloat(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.putFloat(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.putFloat(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.putFloat(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putUUID(TAG_CASTER, this.casterUUID);
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
        compound.putFloat(TAG_COLOR_A, colors[3]);
        compound.putFloat(TAG_COLOR_R2, colors[4]);
        compound.putFloat(TAG_COLOR_G2, colors[5]);
        compound.putFloat(TAG_COLOR_B2, colors[6]);
        compound.putFloat(TAG_DISTANCE, this.getDistance());
        Vec3 look = this.getLookV();
        CompoundTag looknbt = new CompoundTag();
        looknbt.putDouble("x", look.x);
        looknbt.putDouble("y", look.y);
        looknbt.putDouble("z", look.z);
        compound.put(TAG_LOOK_VEC, (Tag)looknbt);
    }

    public boolean isPointInRadiusOfCircle(Vec3 pos) {
        Vec3 sphereMid = this.getSphereMid();
        double distance = pos.distanceTo(sphereMid);
        return distance < (double)this.getSphereMidRadius();
    }

    public boolean isPointInShieldRectangle(Vec3 pos) {
        float xside = 4.0f;
        float yside = 6.0f;
        float zside = 6.0f;
        Vec3 rotatedpos = this.rotateAroundOrigin(pos, EffectUtil.toRad(90.0f - this.getRotationPitch()), EffectUtil.toRad(-this.getRotationRoll() + 90.0f), 0.0f);
        return rotatedpos.x > this.getX() - (double)xside && rotatedpos.x < this.getX() + 0.5 && rotatedpos.y > this.getY() - (double)yside && rotatedpos.y < this.getY() + (double)yside && rotatedpos.z > this.getZ() - (double)zside && rotatedpos.z < this.getZ() + (double)zside;
    }

    public Vec3 getSphereMid() {
        Vec3 sphereMid = this.position().subtract(this.getLookV().normalize().scale((double)this.getSphereMidRadius() - 0.5));
        return sphereMid;
    }

    public int whereIsPoint(Vec3 pos) {
        if (!this.isPointInShieldRectangle(pos)) {
            return 0;
        }
        if (this.isPointInRadiusOfCircle(pos)) {
            return 1;
        }
        return 2;
    }

    public Vec3 rotateAroundOrigin(Vec3 pos, float pitch, float roll, float yaw) {
        Vec3 rho = this.position();
        return rho.add(this.rotateRoll(pos.subtract(rho).yRot(roll), pitch));
    }

    public Vec3 rotateRoll(Vec3 v, float roll) {
        float f = Mth.cos((float)roll);
        float f1 = Mth.sin((float)roll);
        double d0 = v.x * (double)f + v.y * (double)f1;
        double d1 = v.y * (double)f - v.x * (double)f1;
        double d2 = v.z;
        return new Vec3(d0, d1, d2);
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    public float getRotationYaw() {
        return ((Float)this.entityData.get(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.entityData.set(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.entityData.get(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.entityData.set(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.entityData.get(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.entityData.set(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.entityData.get(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.entityData.set(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.entityData.get(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.entityData.set(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public float getDistance() {
        return ((Float)this.entityData.get(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.entityData.set(DISTANCE, (Object)Float.valueOf(d));
    }

    public Vec3 getLookV() {
        CompoundTag nbt = (CompoundTag)this.entityData.get(LOOK_VEC);
        return new Vec3(nbt.getDouble("x"), nbt.getDouble("y"), nbt.getDouble("z"));
    }

    public void setLookV(Vec3 v) {
        if (v != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("x", v.x);
            nbt.putDouble("y", v.y);
            nbt.putDouble("z", v.z);
            this.entityData.set(LOOK_VEC, (Object)nbt);
        }
    }
}

