/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.kodoku;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;

public class KodokuEntity
extends Animal {
    public int kodoku = 0;
    public String KODOKU_TRACKER = "MAHOUTSUKAI_KODOKU_TRACKER";
    public static final String entityName = "kodoku_entity";

    public KodokuEntity(Level worldIn) {
        super((EntityType)ModEntities.KODOKU.get(), worldIn);
        this.setPersistenceRequired();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    public KodokuEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.kodoku = compound.getInt(this.KODOKU_TRACKER);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt(this.KODOKU_TRACKER, this.kodoku);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount);
    }

    public void aiStep() {
        LivingEntity riding;
        super.aiStep();
        if (!this.level().isClientSide && this.getVehicle() instanceof LivingEntity && (riding = (LivingEntity)this.getVehicle()).getHealth() < 5.0f && ServerHandler.tickCounter % 20L == 0L) {
            riding.hurt(this.damageSources().mobAttack((LivingEntity)this), 1.0f);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_EAT, SoundSource.HOSTILE, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.kodoku.get(), 1);
            KodokuItem.setKodoku(stack, this.kodoku);
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
            this.discard();
        }
        return InteractionResult.SUCCESS;
    }
}

