/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.fae;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.fae.FaeAIFollow;
import stepsword.mahoutsukai.entity.fae.FaeAIWander;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.FaeNoisePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FaeEntity
extends Animal
implements FlyingAnimal {
    public static final String entityName = "fae";
    public static final String chime = "";
    public static ResourceKey<LootTable> loot = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"fae"));
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(FaeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";

    public FaeEntity(Level worldIn) {
        super((EntityType)ModEntities.FAE.get(), worldIn);
        this.noCulling = true;
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.randomColor();
    }

    public FaeEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
        this.noCulling = true;
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.randomColor();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        return new FaeEntity((Level)world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FaeAIFollow((PathfinderMob)this, 1.0, 8.0f, 7.0f, 2.0f));
        this.goalSelector.addGoal(2, (Goal)new FaeAIWander((PathfinderMob)this, 1.0, 1));
        this.goalSelector.addGoal(0, (Goal)new BreedGoal((Animal)this, 1.0));
    }

    public void aiStep() {
        float[] colors;
        super.aiStep();
        if (!this.level().isClientSide && (colors = this.getColor())[0] == colors[1] && colors[1] == colors[2]) {
            this.randomColor();
        }
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation pathnavigateflying = new FlyingPathNavigation(this, (Mob)this, worldIn){};
        pathnavigateflying.setCanOpenDoors(false);
        pathnavigateflying.setCanPassDoors(true);
        return pathnavigateflying;
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public AABB getBoundingBoxForCulling() {
        return bb;
    }

    protected void pushEntities() {
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isFood(ItemStack stack) {
        Item[] tasty;
        for (Item item : tasty = new Item[]{(Item)ModItems.powderedEye.get(), (Item)ModItems.powderedEmerald.get(), (Item)ModItems.powderedIron.get(), (Item)ModItems.powderedDiamond.get(), (Item)ModItems.powderedEnder.get(), (Item)ModItems.powderedQuartz.get(), (Item)ModItems.powderedGold.get()}) {
            if (item != stack.getItem()) continue;
            return true;
        }
        return false;
    }

    public void travel(Vec3 v) {
        Vec3 motion = this.getDeltaMovement();
        double motionX = motion.x;
        double motionY = motion.y;
        double motionZ = motion.z;
        float ff = 0.008f;
        if (!Utils.isBlockAir(this.level(), this.blockPosition().below())) {
            motionY += (double)ff;
        }
        this.setDeltaMovement(motionX, motionY, motionZ);
        if (this.isInWater()) {
            this.moveRelative(0.02f, v);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(0.02f, v);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            float f = 0.91f;
            float f1 = 0.16277136f / (f * f * f);
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, v);
            f = 0.91f;
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale((double)f));
        }
        double d1 = this.getX() - this.xo;
        double d0 = this.getZ() - this.zo;
        float f2 = Mth.sqrt((float)((float)(d1 * d1 + d0 * d0))) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.walkAnimation.setSpeed(this.walkAnimation.speed() + (f2 - this.walkAnimation.speed()) * 0.4f);
        this.walkAnimation.position += this.walkAnimation.speed();
    }

    public void randomColor() {
        float b;
        float g;
        float r;
        int choice = this.getRandom().nextInt(11);
        if (choice == 0) {
            r = 140.0f;
            g = 0.0f;
            b = 255.0f;
        } else if (choice == 1) {
            r = 51.0f;
            g = 241.0f;
            b = 255.0f;
        } else if (choice == 2) {
            r = 255.0f;
            g = 94.0f;
            b = 0.0f;
        } else if (choice == 3) {
            r = 0.0f;
            g = 222.0f;
            b = 18.0f;
        } else if (choice == 4) {
            r = 255.0f;
            g = 0.0f;
            b = 0.0f;
        } else if (choice == 5) {
            r = 255.0f;
            g = 209.0f;
            b = 41.0f;
        } else if (choice == 6) {
            r = 26.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 7) {
            r = 68.0f;
            g = 5.0f;
            b = 255.0f;
        } else if (choice == 8) {
            r = 255.0f;
            g = 150.0f;
            b = 201.0f;
        } else if (choice == 9) {
            r = 172.0f;
            g = 255.0f;
            b = 28.0f;
        } else {
            r = 255.0f;
            g = 28.0f;
            b = 77.0f;
        }
        this.setColor(r, g, b);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_G, (Object)Float.valueOf(1.0f));
        builder.define(COLOR_B, (Object)Float.valueOf(1.0f));
    }

    public void setColor(float r, float g, float b) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(r));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(g));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(b));
        this.setSilent(false);
    }

    public float[] getColor() {
        return new float[]{((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue()};
    }

    public float getScale() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        boolean faesound;
        boolean bl = faesound = MTConfig.FAE_NOISE && MahouTsukaiMod.proxy.isMahouTsukai();
        if (faesound) {
            int z = this.getRandom().nextInt(4);
            SoundEvent[] arr = new SoundEvent[]{(SoundEvent)ModSounds.FAE_CHIME_1.get(), (SoundEvent)ModSounds.FAE_CHIME_2.get(), (SoundEvent)ModSounds.FAE_CHIME_3.get(), (SoundEvent)ModSounds.FAE_CHIME_4.get()};
            return arr[z];
        }
        return null;
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.playSound(soundevent, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        if (!this.isSilent() && !this.level().isClientSide) {
            this.playSound(this.getX(), this.getY(), this.getZ(), soundIn, this.getSoundSource(), volume, pitch);
        }
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
        PlayLevelSoundEvent.AtEntity event = EventHooks.onPlaySoundAtEntity((Entity)this, (Holder)new Holder.Direct((Object)soundIn), (SoundSource)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = (SoundEvent)event.getSound().value();
        category = event.getSource();
        volume = event.getNewVolume();
        this.sendToAllNear(this.level().getServer().getPlayerList(), x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, EffectUtil.getDimension(this.level()), new FaeNoisePacket((int)x, (int)y, (int)z, soundIn, category, volume, pitch));
    }

    public void sendToAllNear(PlayerList list, double x, double y, double z, double radius, ResourceLocation dimension, FaeNoisePacket packetIn) {
        if (list != null) {
            for (int i = 0; i < list.getPlayers().size(); ++i) {
                double d2;
                double d1;
                double d0;
                ServerPlayer serverPlayer = (ServerPlayer)list.getPlayers().get(i);
                IMahou mahou = Utils.getPlayerMahou((Player)serverPlayer);
                if (mahou == null || !mahou.hasMagic() || !EffectUtil.compareDimensions(EffectUtil.getDimension(serverPlayer.level()), dimension) || !((d0 = x - serverPlayer.getX()) * d0 + (d1 = y - serverPlayer.getY()) * d1 + (d2 = z - serverPlayer.getZ()) * d2 < radius * radius)) continue;
                PacketHandler.sendTo(serverPlayer, packetIn);
            }
        }
    }

    @Nullable
    protected ResourceKey<LootTable> getDefaultLootTable() {
        return loot;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.FLYING_SPEED, (double)0.8f).add(Attributes.MOVEMENT_SPEED, (double)0.4f);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType reason) {
        if (reason == MobSpawnType.BREEDING || reason == MobSpawnType.SPAWN_EGG || reason == MobSpawnType.MOB_SUMMONED) {
            return true;
        }
        Leylines.LeyLineShape keepshape = Leylines.LeyLineShape.NONE;
        ChunkPos cp = new ChunkPos(this.blockPosition());
        for (int i = cp.getMinBlockX(); i <= cp.getMaxBlockX(); ++i) {
            for (int j = cp.getMinBlockZ(); j <= cp.getMaxBlockZ(); ++j) {
                Leylines.LeyLineShape shape = Leylines.leyOrientation(new BlockPos(i, 0, j));
                if (keepshape == Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape == Leylines.LeyLineShape.NED || keepshape == Leylines.LeyLineShape.NWD || keepshape == Leylines.LeyLineShape.HORIZ || keepshape == Leylines.LeyLineShape.VERT && shape != Leylines.LeyLineShape.NONE) {
                    keepshape = shape;
                }
                if (keepshape != Leylines.LeyLineShape.CROSS || shape != Leylines.LeyLineShape.STAR) continue;
                keepshape = Leylines.LeyLineShape.STAR;
            }
        }
        float thresh = 1.0f;
        thresh = keepshape == Leylines.LeyLineShape.CROSS ? 0.2f : (keepshape == Leylines.LeyLineShape.STAR ? 0.0f : (keepshape == Leylines.LeyLineShape.NONE ? 0.7f : 0.4f));
        thresh = (float)((double)thresh * MTConfig.FAE_SPAWN_RATE);
        return Math.random() > (double)thresh && super.checkSpawnRules(world, reason);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return super.isInvulnerableTo(source) || source == this.damageSources().inWall() || source == this.damageSources().flyIntoWall() || source == this.damageSources().fall();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        float[] colors = this.getColor();
        compound.putFloat(TAG_COLOR_R, colors[0]);
        compound.putFloat(TAG_COLOR_G, colors[1]);
        compound.putFloat(TAG_COLOR_B, colors[2]);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setColor(compound.getFloat(TAG_COLOR_R), compound.getFloat(TAG_COLOR_G), compound.getFloat(TAG_COLOR_B));
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean isInvisibleTo(Player player) {
        return !EffectUtil.hasBuff((LivingEntity)player, ModEffects.FAY_SIGHT_EYES);
    }
}

