/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.networking.MentalDisplacementUpdatePacket;
import stepsword.mahoutsukai.networking.PacketHandler;

public class MentalDisplacementEntity
extends Entity {
    public static final String entityName = "mental_displacement";
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(MentalDisplacementEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public BlockPos origPos;
    public Player player;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean backInputDown;
    private boolean forwardInputDown;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean upInputDown;
    private boolean downInputDown;
    public boolean used = false;

    public MentalDisplacementEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MentalDisplacementEntity(Level world) {
        super((EntityType)ModEntities.MENTAL_DISPLACEMENT.get(), world);
        this.origPos = null;
        this.player = null;
    }

    public MentalDisplacementEntity(Level world, BlockPos o, Player p) {
        this(world);
        this.origPos = o;
        this.player = p;
        this.setPos(this.origPos.getX(), this.origPos.getY(), this.origPos.getZ());
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.yRot = p.yRot;
        this.xRot = p.xRot;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d1 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d2 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double d3 = Mth.wrapDegrees((double)(this.lerpYaw - (double)this.yRot));
            this.yRot = (float)((double)this.yRot + d3 / (double)this.lerpSteps);
            this.xRot = (float)((double)this.xRot + (this.lerpPitch - (double)this.xRot) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(d0, d1, d2);
            this.setRot(this.yRot, this.xRot);
        }
    }

    public boolean isControlledByLocalInstance() {
        return false;
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.player == null) {
                this.discard();
                return;
            }
            if (!this.player.isAlive()) {
                this.discard();
                return;
            }
            if (MentalDisplacementSpellEffect.checkDistance(this.player.blockPosition(), this.blockPosition()) > MTConfig.MENTAL_DISPLACEMENT_RANGE) {
                this.discard();
                return;
            }
        }
        this.setRot(this.yRot, this.xRot);
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3 motion = this.getDeltaMovement();
        Vec3 position = this.position().add(motion);
        this.setPos(position.x, position.y, position.z);
        this.tickLerp();
        this.playerControl();
    }

    public void playerControl() {
        if (this.level().isClientSide) {
            float moveSpeed = 0.01f;
            float slowFactor = 0.1f;
            float f = 1.0E-8f;
            float l = 1.0E-8f;
            float u = 0.0f;
            float fm = 0.0f;
            float lm = 0.0f;
            float um = 1.0f;
            if (this.backInputDown) {
                f += -moveSpeed;
            }
            if (this.forwardInputDown) {
                f += moveSpeed;
            }
            if (this.leftInputDown) {
                l += moveSpeed;
            }
            if (this.rightInputDown) {
                l += -moveSpeed;
            }
            if (this.upInputDown) {
                u += moveSpeed;
            }
            if (this.downInputDown) {
                u += -moveSpeed;
            }
            if (!this.forwardInputDown && !this.backInputDown) {
                fm = 1.0f;
            }
            if (!this.leftInputDown && !this.rightInputDown) {
                lm = 1.0f;
            }
            if (!this.upInputDown && !this.downInputDown) {
                um = slowFactor;
            }
            Vec3 motion = this.getDeltaMovement();
            this.setDeltaMovement(motion.x + (double)(-(Mth.sin((float)(this.yRot * ((float)Math.PI / 180))) * f)) + (double)(Mth.cos((float)(this.yRot * ((float)Math.PI / 180))) * l), motion.y, motion.z + (double)(Mth.cos((float)(this.yRot * ((float)Math.PI / 180))) * f) + (double)(Mth.sin((float)(this.yRot * ((float)Math.PI / 180))) * l));
            motion = this.getDeltaMovement();
            double g = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
            float angle = (float)(-Math.atan2(motion.x, motion.z)) * 57.2958f;
            double c = g * (double)Mth.cos((float)((angle - this.yRot + 90.0f) * ((float)Math.PI / 180)));
            double c2 = c * (double)Mth.cos((float)(this.yRot * ((float)Math.PI / 180)));
            double c1 = c * (double)Mth.sin((float)(this.yRot * ((float)Math.PI / 180)));
            double d = g * (double)Mth.cos((float)((angle - this.yRot) * ((float)Math.PI / 180)));
            double d2 = -d * (double)Mth.sin((float)(this.yRot * ((float)Math.PI / 180)));
            double d1 = d * (double)Mth.cos((float)(this.yRot * ((float)Math.PI / 180)));
            this.setDeltaMovement(motion.x - (double)lm * c2 - (double)fm * d2, (double)um * ((double)u + motion.y), motion.z - (double)lm * c1 - (double)fm * d1);
            Vec3 v = this.position().add(this.getDeltaMovement());
            this.setPos(v.x, v.y, v.z);
            Vec3 dm = this.getDeltaMovement();
            Vec3 pp = this.position();
            PacketHandler.sendToServer(new MentalDisplacementUpdatePacket(this, pp.x, pp.y, pp.z, dm.x, dm.y, dm.z, this.yRot, this.xRot));
        }
    }

    public void updatePacket(MentalDisplacementUpdatePacket packet) {
        this.setPos(packet.x, packet.y, packet.z);
        this.setDeltaMovement(packet.vx, packet.vy, packet.vz);
        this.setRot((float)packet.yaw, (float)packet.pitch);
    }

    public void updateInputs(boolean b, boolean f, boolean l, boolean r, boolean u, boolean d) {
        this.backInputDown = b;
        this.forwardInputDown = f;
        this.leftInputDown = l;
        this.rightInputDown = r;
        this.upInputDown = u;
        this.downInputDown = d;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.used = compound.getBoolean("mahoutsukai_used");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("mahoutsukai_used", this.used);
    }

    public AABB getBoundingBox() {
        return new AABB(this.getX() - 0.1, this.getY() - 0.1, this.getZ() - 0.1, this.getX() + 0.1, this.getY() + 0.1, this.getZ() + 0.1);
    }

    public AABB getBoundingBoxForCulling() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }
}

